/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.service;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.SyncedSingletonAnimatableCache;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.network.packet.blockentity.BlockEntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.blockentity.BlockEntityDataSyncPacket;
import software.bernie.geckolib.network.packet.blockentity.StatelessBlockEntityPlayAnimPacket;
import software.bernie.geckolib.network.packet.blockentity.StatelessBlockEntityStopAnimPacket;
import software.bernie.geckolib.network.packet.blockentity.StopTriggeredBlockEntityAnimPacket;
import software.bernie.geckolib.network.packet.entity.EntityAnimTriggerPacket;
import software.bernie.geckolib.network.packet.entity.EntityDataSyncPacket;
import software.bernie.geckolib.network.packet.entity.StatelessEntityPlayAnimPacket;
import software.bernie.geckolib.network.packet.entity.StatelessEntityStopAnimPacket;
import software.bernie.geckolib.network.packet.entity.StopTriggeredEntityAnimPacket;
import software.bernie.geckolib.network.packet.singleton.SingletonAnimTriggerPacket;
import software.bernie.geckolib.network.packet.singleton.SingletonDataSyncPacket;
import software.bernie.geckolib.network.packet.singleton.StatelessSingletonPlayAnimPacket;
import software.bernie.geckolib.network.packet.singleton.StatelessSingletonStopAnimPacket;
import software.bernie.geckolib.network.packet.singleton.StopTriggeredSingletonAnimPacket;

public interface GeckoLibNetworking {
    public static void init() {
        GeckoLibNetworking.registerPacket(BlockEntityDataSyncPacket.TYPE, BlockEntityDataSyncPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(EntityDataSyncPacket.TYPE, EntityDataSyncPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(SingletonDataSyncPacket.TYPE, SingletonDataSyncPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(BlockEntityAnimTriggerPacket.TYPE, BlockEntityAnimTriggerPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(SingletonAnimTriggerPacket.TYPE, SingletonAnimTriggerPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(EntityAnimTriggerPacket.TYPE, EntityAnimTriggerPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StopTriggeredBlockEntityAnimPacket.TYPE, StopTriggeredBlockEntityAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StopTriggeredEntityAnimPacket.TYPE, StopTriggeredEntityAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StopTriggeredSingletonAnimPacket.TYPE, StopTriggeredSingletonAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StatelessEntityPlayAnimPacket.TYPE, StatelessEntityPlayAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StatelessBlockEntityPlayAnimPacket.TYPE, StatelessBlockEntityPlayAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StatelessSingletonPlayAnimPacket.TYPE, StatelessSingletonPlayAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StatelessEntityStopAnimPacket.TYPE, StatelessEntityStopAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StatelessBlockEntityStopAnimPacket.TYPE, StatelessBlockEntityStopAnimPacket.CODEC, true);
        GeckoLibNetworking.registerPacket(StatelessSingletonStopAnimPacket.TYPE, StatelessSingletonStopAnimPacket.CODEC, true);
    }

    @ApiStatus.Internal
    private static <B extends class_2540, P extends MultiloaderPacket> void registerPacket(class_8710.class_9154<P> payloadType, class_9139<B, P> codec, boolean isClientBound) {
        GeckoLibServices.NETWORK.registerPacketInternal(payloadType, codec, isClientBound);
    }

    @ApiStatus.Internal
    public <B extends class_2540, P extends MultiloaderPacket> void registerPacketInternal(class_8710.class_9154<P> var1, class_9139<B, P> var2, boolean var3);

    public void sendToAllPlayersTrackingEntity(MultiloaderPacket var1, class_1297 var2);

    public void sendToAllPlayersTrackingBlock(MultiloaderPacket var1, class_3218 var2, class_2338 var3);

    public void sendToPlayer(MultiloaderPacket var1, class_3222 var2);

    default public <D> void syncBlockEntityAnimData(class_2338 pos, SerializableDataTicket<D> dataTicket, D data, class_3218 level) {
        this.sendToAllPlayersTrackingBlock(new BlockEntityDataSyncPacket<D>(pos, dataTicket, data), level, pos);
    }

    default public <D> void syncEntityAnimData(class_1297 entity, boolean isReplacedEntity, SerializableDataTicket<D> dataTicket, D data) {
        this.sendToAllPlayersTrackingEntity(new EntityDataSyncPacket<D>(entity.method_5628(), isReplacedEntity, dataTicket, data), entity);
    }

    default public <D> void syncSingletonAnimData(SingletonGeoAnimatable animatable, long instanceId, SerializableDataTicket<D> dataTicket, D data, class_1297 entityToTrack) {
        this.sendToAllPlayersTrackingEntity(new SingletonDataSyncPacket<D>(SyncedSingletonAnimatableCache.getOrCreateId(animatable), instanceId, dataTicket, data), entityToTrack);
    }

    default public void triggerBlockEntityAnim(class_2338 pos, class_3218 level, @Nullable String controllerName, String animName) {
        this.sendToAllPlayersTrackingBlock(new BlockEntityAnimTriggerPacket(pos, Optional.ofNullable(controllerName), animName), level, pos);
    }

    default public void triggerEntityAnim(class_1297 entity, boolean isReplacedEntity, @Nullable String controllerName, String animName) {
        this.sendToAllPlayersTrackingEntity(new EntityAnimTriggerPacket(entity.method_5628(), isReplacedEntity, Optional.ofNullable(controllerName), animName), entity);
    }

    default public void triggerSingletonAnim(SingletonGeoAnimatable animatable, class_1297 entityToTrack, long instanceId, @Nullable String controllerName, String animName) {
        this.sendToAllPlayersTrackingEntity(new SingletonAnimTriggerPacket(SyncedSingletonAnimatableCache.getOrCreateId(animatable), instanceId, Optional.ofNullable(controllerName), animName), entityToTrack);
    }

    default public void stopTriggeredBlockEntityAnim(class_2338 pos, class_3218 level, @Nullable String controllerName, @Nullable String animName) {
        this.sendToAllPlayersTrackingBlock(new StopTriggeredBlockEntityAnimPacket(pos, Optional.ofNullable(controllerName), Optional.ofNullable(animName)), level, pos);
    }

    default public void stopTriggeredEntityAnim(class_1297 entity, boolean isReplacedEntity, @Nullable String controllerName, @Nullable String animName) {
        this.sendToAllPlayersTrackingEntity(new StopTriggeredEntityAnimPacket(entity.method_5628(), isReplacedEntity, Optional.ofNullable(controllerName), Optional.ofNullable(animName)), entity);
    }

    default public void stopTriggeredSingletonAnim(SingletonGeoAnimatable animatable, class_1297 entityToTrack, long instanceId, @Nullable String controllerName, @Nullable String animName) {
        this.sendToAllPlayersTrackingEntity(new StopTriggeredSingletonAnimPacket(SyncedSingletonAnimatableCache.getOrCreateId(animatable), instanceId, Optional.ofNullable(controllerName), Optional.ofNullable(animName)), entityToTrack);
    }
}

