/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.processing;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableObject;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.EasingType;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.keyframe.AnimationPoint;
import software.bernie.geckolib.animation.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.loading.math.MolangQueries;
import software.bernie.geckolib.loading.math.value.Variable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.util.ClientUtil;

public class AnimationProcessor<T extends GeoAnimatable> {
    private final Map<String, GeoBone> bones = new Object2ObjectOpenHashMap();
    private final GeoModel<T> model;
    public boolean reloadAnimations = false;

    public AnimationProcessor(GeoModel<T> model) {
        this.model = model;
    }

    public void prepareForRenderPass(T animatable, AnimatableManager<T> animatableManager, GeoRenderState renderState, double lerpedAnimationTick, GeoModel<T> model) {
        MolangQueries.Actor<T> actor = new MolangQueries.Actor<T>(animatable, renderState, new MutableObject(), lerpedAnimationTick, renderState.getGeckolibData(DataTickets.PARTIAL_TICK).floatValue(), ClientUtil.getLevel(), ClientUtil.getClientPlayer(), ClientUtil.getCameraPos());
        Reference2DoubleOpenHashMap variables = new Reference2DoubleOpenHashMap();
        renderState.addGeckolibData(DataTickets.QUERY_VALUES, variables);
        for (AnimationController<T> controller : animatableManager.getAnimationControllers().values()) {
            actor.controller().setValue(controller);
            controller.prepareForRenderPass(animatable, animatableManager, actor, (Reference2DoubleMap<Variable>)variables, lerpedAnimationTick, model);
        }
    }

    public Queue<QueuedAnimation> buildAnimationQueue(T animatable, RawAnimation rawAnimation) {
        LinkedList<QueuedAnimation> animations = new LinkedList<QueuedAnimation>();
        boolean error = false;
        for (RawAnimation.Stage stage : rawAnimation.getAnimationStages()) {
            Animation animation = null;
            if (stage.animationName() == "internal.wait") {
                animation = Animation.generateWaitAnimation(stage.additionalTicks());
            } else {
                try {
                    animation = this.model.getAnimation(animatable, stage.animationName());
                }
                catch (RuntimeException ex) {
                    GeckoLibConstants.LOGGER.error("Error while retrieving animation for animatable '{}'", (Object)animatable.getClass().getName(), (Object)ex);
                    error = true;
                }
            }
            if (animation == null) continue;
            animations.add(new QueuedAnimation(animation, stage.loopType()));
        }
        return error ? null : animations;
    }

    public void tickAnimation(AnimationState<T> animationState) {
        AnimatableManager<T> animatableManager = animationState.manager();
        Map<String, BoneSnapshot> boneSnapshots = this.updateBoneSnapshots(animatableManager.getBoneSnapshotCollection());
        double lerpedAnimationTick = animationState.getData(DataTickets.ANIMATION_TICKS);
        for (AnimationController<T> controller : animatableManager.getAnimationControllers().values()) {
            if (this.reloadAnimations) {
                controller.forceAnimationReset();
                controller.getBoneAnimationQueues().clear();
            }
            controller.beginTick(animationState, this.bones, boneSnapshots, lerpedAnimationTick);
            for (BoneAnimationQueue boneAnimation : controller.getBoneAnimationQueues().values()) {
                GeoBone bone = boneAnimation.bone();
                BoneSnapshot snapshot = boneSnapshots.get(bone.getName());
                BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                AnimationPoint rotXPoint = boneAnimation.rotationXQueue().poll();
                AnimationPoint rotYPoint = boneAnimation.rotationYQueue().poll();
                AnimationPoint rotZPoint = boneAnimation.rotationZQueue().poll();
                AnimationPoint posXPoint = boneAnimation.positionXQueue().poll();
                AnimationPoint posYPoint = boneAnimation.positionYQueue().poll();
                AnimationPoint posZPoint = boneAnimation.positionZQueue().poll();
                AnimationPoint scaleXPoint = boneAnimation.scaleXQueue().poll();
                AnimationPoint scaleYPoint = boneAnimation.scaleYQueue().poll();
                AnimationPoint scaleZPoint = boneAnimation.scaleZQueue().poll();
                EasingType easingType = controller.overrideEasingTypeFunction.apply(animationState);
                if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                    bone.setRotX((float)EasingType.lerpWithOverride(rotXPoint, easingType, animationState) + initialSnapshot.getRotX());
                    bone.setRotY((float)EasingType.lerpWithOverride(rotYPoint, easingType, animationState) + initialSnapshot.getRotY());
                    bone.setRotZ((float)EasingType.lerpWithOverride(rotZPoint, easingType, animationState) + initialSnapshot.getRotZ());
                    snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    snapshot.startRotAnim();
                    bone.markRotationAsChanged();
                }
                if (posXPoint != null && posYPoint != null && posZPoint != null) {
                    bone.setPosX((float)EasingType.lerpWithOverride(posXPoint, easingType, animationState));
                    bone.setPosY((float)EasingType.lerpWithOverride(posYPoint, easingType, animationState));
                    bone.setPosZ((float)EasingType.lerpWithOverride(posZPoint, easingType, animationState));
                    snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    snapshot.startPosAnim();
                    bone.markPositionAsChanged();
                }
                if (scaleXPoint == null || scaleYPoint == null || scaleZPoint == null) continue;
                bone.setScaleX((float)EasingType.lerpWithOverride(scaleXPoint, easingType, animationState));
                bone.setScaleY((float)EasingType.lerpWithOverride(scaleYPoint, easingType, animationState));
                bone.setScaleZ((float)EasingType.lerpWithOverride(scaleZPoint, easingType, animationState));
                snapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                snapshot.startScaleAnim();
                bone.markScaleAsChanged();
            }
            controller.finishRenderPass();
        }
        this.reloadAnimations = false;
        double resetTickLength = animationState.getData(DataTickets.BONE_RESET_TIME);
        for (GeoBone bone : this.getRegisteredBones()) {
            double percentageReset;
            BoneSnapshot saveSnapshot;
            BoneSnapshot initialSnapshot;
            if (!bone.hasRotationChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isRotAnimInProgress()) {
                    saveSnapshot.stopRotAnim(lerpedAnimationTick);
                }
                percentageReset = resetTickLength == 0.0 ? 1.0 : Math.min((lerpedAnimationTick - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
                float initialRotX = initialSnapshot.getRotX();
                float initialRotY = initialSnapshot.getRotY();
                float initialRotZ = initialSnapshot.getRotZ();
                float lastXRot = saveSnapshot.getRotX();
                float lastYRot = saveSnapshot.getRotY();
                float lastZRot = saveSnapshot.getRotZ();
                if (percentageReset == 0.0) {
                    if (lastXRot != initialRotX && this.isSuspectedCompletedRotation(lastXRot)) {
                        lastXRot = initialRotX;
                        percentageReset = 1.0;
                    }
                    if (lastYRot != initialRotY && this.isSuspectedCompletedRotation(lastYRot)) {
                        lastYRot = initialRotY;
                        percentageReset = 1.0;
                    }
                    if (lastZRot != initialRotZ && this.isSuspectedCompletedRotation(lastZRot)) {
                        lastZRot = initialRotZ;
                        percentageReset = 1.0;
                    }
                }
                bone.setRotX((float)Mth.lerp((double)percentageReset, (double)lastXRot, (double)initialRotX));
                bone.setRotY((float)Mth.lerp((double)percentageReset, (double)lastYRot, (double)initialRotY));
                bone.setRotZ((float)Mth.lerp((double)percentageReset, (double)lastZRot, (double)initialRotZ));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                }
            }
            if (!bone.hasPositionChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isPosAnimInProgress()) {
                    saveSnapshot.stopPosAnim(lerpedAnimationTick);
                }
                percentageReset = resetTickLength == 0.0 ? 1.0 : Math.min((lerpedAnimationTick - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
                bone.setPosX((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX()));
                bone.setPosY((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY()));
                bone.setPosZ((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ()));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                }
            }
            if (bone.hasScaleChanged()) continue;
            initialSnapshot = bone.getInitialSnapshot();
            saveSnapshot = boneSnapshots.get(bone.getName());
            if (saveSnapshot.isScaleAnimInProgress()) {
                saveSnapshot.stopScaleAnim(lerpedAnimationTick);
            }
            percentageReset = resetTickLength == 0.0 ? 1.0 : Math.min((lerpedAnimationTick - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
            bone.setScaleX((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX()));
            bone.setScaleY((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY()));
            bone.setScaleZ((float)Mth.lerp((double)percentageReset, (double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ()));
            if (!(percentageReset >= 1.0)) continue;
            saveSnapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
        }
        this.resetBoneTransformationMarkers();
        animatableManager.finishFirstTick();
    }

    private boolean isSuspectedCompletedRotation(float lastRotation) {
        float rotations = Mth.abs((float)(lastRotation / ((float)Math.PI * 2)));
        float partialRotation = 1.0f - (rotations - (float)((int)rotations));
        return partialRotation == 1.0f || (double)partialRotation < 0.026 * (double)rotations;
    }

    private void resetBoneTransformationMarkers() {
        this.getRegisteredBones().forEach(GeoBone::resetStateChanges);
    }

    private Map<String, BoneSnapshot> updateBoneSnapshots(Map<String, BoneSnapshot> snapshots) {
        for (GeoBone bone : this.getRegisteredBones()) {
            if (snapshots.containsKey(bone.getName())) continue;
            snapshots.put(bone.getName(), BoneSnapshot.copy(bone.getInitialSnapshot()));
        }
        return snapshots;
    }

    public GeoBone getBone(String boneName) {
        return this.bones.get(boneName);
    }

    public void registerGeoBone(GeoBone bone) {
        bone.saveInitialSnapshot();
        this.bones.put(bone.getName(), bone);
        for (GeoBone child : bone.getChildBones()) {
            this.registerGeoBone(child);
        }
    }

    public void setActiveModel(BakedGeoModel model) {
        this.bones.clear();
        for (GeoBone bone : model.topLevelBones()) {
            this.registerGeoBone(bone);
        }
    }

    public Collection<GeoBone> getRegisteredBones() {
        return this.bones.values();
    }

    public record QueuedAnimation(Animation animation, Animation.LoopType loopType) {
    }
}

