/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet.singleton;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.cache.SyncedSingletonAnimatableCache;
import software.bernie.geckolib.network.packet.MultiloaderPacket;

public record StopTriggeredSingletonAnimPacket(String syncableId, long instanceId, Optional<String> controllerName, Optional<String> animName) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<StopTriggeredSingletonAnimPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("stop_triggered_singleton_anim"));
    public static final StreamCodec<FriendlyByteBuf, StopTriggeredSingletonAnimPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, StopTriggeredSingletonAnimPacket::syncableId, (StreamCodec)ByteBufCodecs.VAR_LONG, StopTriggeredSingletonAnimPacket::instanceId, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), StopTriggeredSingletonAnimPacket::controllerName, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), StopTriggeredSingletonAnimPacket::animName, StopTriggeredSingletonAnimPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            AnimatableManager animatableManager;
            GeoAnimatable animatable = SyncedSingletonAnimatableCache.getSyncedAnimatable(this.syncableId);
            if (animatable != null && (animatableManager = animatable.getAnimatableInstanceCache().getManagerForId(this.instanceId)) != null) {
                animatableManager.stopTriggeredAnimation(this.controllerName.orElse(null), this.animName.orElse(null));
            }
        });
    }
}

