/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.specialty;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class DyeableGeoArmorRenderer<T extends Item, R extends HumanoidRenderState>
extends GeoArmorRenderer<T, R> {
    protected final Set<GeoBone> dyeableBones = new ReferenceOpenHashSet();
    protected BakedGeoModel lastModel = null;

    public DyeableGeoArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    protected abstract boolean isBoneDyeable(GeoBone var1);

    protected int getColorForBone(R renderState, GeoBone bone, int packedLight, int packedOverlay, int baseColour) {
        return baseColour;
    }

    @Override
    public int getRenderColor(T animatable, GeoArmorRenderer.RenderData stackAndSlot, float partialTick) {
        return -1;
    }

    @Override
    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        super.preRender(renderState, poseStack, model, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
        this.checkBoneDyeCache((GeoRenderState)renderState, model, packedLight, packedOverlay, renderColor);
    }

    @Override
    public void renderCubesOfBone(R renderState, GeoBone bone, PoseStack poseStack, VertexConsumer buffer, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (this.dyeableBones.contains(bone)) {
            renderColor = ARGB.multiply((int)renderColor, (int)this.getColorForBone(renderState, bone, packedLight, packedOverlay, ((GeoRenderState)renderState).getGeckolibData(DataTickets.RENDER_COLOR)));
        }
        super.renderCubesOfBone(renderState, bone, poseStack, buffer, cameraState, packedLight, packedOverlay, renderColor);
    }

    protected void checkBoneDyeCache(GeoRenderState renderState, BakedGeoModel model, int packedLight, int packedOverlay, int renderColor) {
        if (model != this.lastModel) {
            this.lastModel = model;
            this.dyeableBones.clear();
            this.collectDyeableBones(model.topLevelBones());
        }
    }

    protected void collectDyeableBones(Collection<GeoBone> bones) {
        for (GeoBone bone : bones) {
            if (this.isBoneDyeable(bone)) {
                this.dyeableBones.add(bone);
            }
            this.collectDyeableBones(bone.getChildBones());
        }
    }
}

