/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.payload.PayloadFlow;
import net.minecraftforge.network.payload.PayloadProtocol;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.service.GeckoLibNetworking;
import software.bernie.geckolib.util.ClientUtil;

public final class GeckoLibNetworkingForge
implements GeckoLibNetworking {
    public static PayloadProtocol<RegistryFriendlyByteBuf, CustomPacketPayload> NETWORK_CHANNEL_BUILDER = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"geckolib", (String)"main")).networkProtocolVersion(1).optional().payloadChannel().play();
    public static Channel<CustomPacketPayload> CHANNEL;

    public static void init() {
        GeckoLibNetworking.init();
        CHANNEL = ((PayloadFlow)NETWORK_CHANNEL_BUILDER.bidirectional()).build();
    }

    @Override
    public <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacketInternal(CustomPacketPayload.Type<P> packetType, StreamCodec<B, P> codec, boolean isClientBound) {
        if (isClientBound) {
            ((PayloadFlow)NETWORK_CHANNEL_BUILDER.clientbound()).add(packetType, codec, (packet, context) -> {
                packet.receiveMessage((Player)(context.getSender() != null ? context.getSender() : ClientUtil.getClientPlayer()), arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
                context.setPacketHandled(true);
            });
        } else {
            ((PayloadFlow)NETWORK_CHANNEL_BUILDER.serverbound()).add(packetType, codec, (packet, context) -> {
                packet.receiveMessage((Player)(context.getSender() != null ? context.getSender() : ClientUtil.getClientPlayer()), arg_0 -> ((CustomPayloadEvent.Context)context).enqueueWork(arg_0));
                context.setPacketHandled(true);
            });
        }
    }

    @Override
    public void sendToAllPlayersTrackingEntity(MultiloaderPacket packet, Entity trackingEntity) {
        CHANNEL.send((Object)packet, PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)trackingEntity));
    }

    @Override
    public void sendToAllPlayersTrackingBlock(MultiloaderPacket packet, ServerLevel level, BlockPos pos) {
        CHANNEL.send((Object)packet, PacketDistributor.TRACKING_CHUNK.with((Object)level.getChunkAt(pos)));
    }

    @Override
    public void sendToPlayer(MultiloaderPacket packet, ServerPlayer player) {
        CHANNEL.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }
}

