/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.platform;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.service.GeckoLibClient;

public final class GeckoLibClientForge
implements GeckoLibClient {
    @Override
    @NotNull
    public <S extends HumanoidRenderState> Model<?> getArmorModelForItem(S entityRenderState, ItemStack stack, EquipmentSlot slot, EquipmentClientInfo.LayerType type, HumanoidModel<S> defaultModel) {
        return IClientItemExtensions.of((ItemStack)stack).getGenericArmorModel(entityRenderState, stack, slot, defaultModel);
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForItem(ItemStack item) {
        GeoItemRenderer<?> geoItemRenderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (geoItemRenderer instanceof GeoRenderer) {
            GeoItemRenderer<?> geoRenderer = geoItemRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Override
    public int getDyedItemColor(ItemStack itemStack, int defaultColor) {
        return itemStack.is(ItemTags.DYEABLE) ? DyedItemColor.getOrDefault((ItemStack)itemStack, (int)defaultColor) : defaultColor;
    }
}

