/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.base.PerBoneRender;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public abstract class BlockAndItemGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    public BlockAndItemGeoLayer(GeoRenderer<T, O, R> renderer) {
        super(renderer);
    }

    protected abstract List<RenderData<R>> getRelevantBones(R var1, BakedGeoModel var2);

    @Override
    public abstract void addRenderData(T var1, O var2, R var3, float var4);

    @Override
    public void addPerBoneRender(R renderState, BakedGeoModel model, boolean didRenderModel, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        if (!didRenderModel) {
            return;
        }
        for (RenderData<R> renderData : this.getRelevantBones(renderState, model)) {
            model.getBone(renderData.boneName).ifPresentOrElse(bone -> this.createPerBoneRender((GeoBone)bone, renderData, consumer, renderState), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(GeoBone bone, RenderData<R> renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer, R renderState) {
        Either<ItemStack, BlockState> renderObject = renderData.retrievalFunction().apply(bone, renderState);
        renderObject.ifLeft(stack -> {
            if (!stack.isEmpty()) {
                consumer.accept(bone, (renderState2, poseStack, bone2, renderTasks, cameraState, packedLight, packedOverlay, renderColor) -> this.submitItemStackRender(poseStack, bone2, (ItemStack)stack, renderData.displayContext, (R)renderState2, renderTasks, cameraState, packedLight, packedOverlay, renderColor));
            }
        }).ifRight(blockState -> {
            if (!blockState.isAir()) {
                consumer.accept(bone, (renderState2, poseStack, bone2, renderTasks, cameraState, packedLight, packedOverlay, renderColor) -> this.submitBlockRender(poseStack, bone2, (BlockState)blockState, (R)renderState2, renderTasks, cameraState, packedLight, packedOverlay, renderColor));
            }
        });
    }

    protected void submitItemStackRender(PoseStack poseStack, GeoBone bone, ItemStack stack, ItemDisplayContext displayContext, R renderState, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        ItemStackRenderState stackRenderState = new ItemStackRenderState();
        Minecraft mc = Minecraft.getInstance();
        mc.getItemModelResolver().updateForTopItem(stackRenderState, stack, displayContext, (Level)mc.level, null, (int)renderState.getOrDefaultGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, 0L).longValue() + displayContext.ordinal());
        stackRenderState.submit(poseStack, renderTasks, packedLight, OverlayTexture.NO_OVERLAY, 0);
    }

    protected void submitBlockRender(PoseStack poseStack, GeoBone bone, BlockState state, R renderState, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        int n;
        poseStack.pushPose();
        poseStack.translate(-0.25f, -0.25f, -0.25f);
        poseStack.scale(0.5f, 0.5f, 0.5f);
        if (renderState instanceof EntityRenderState) {
            EntityRenderState entityState = (EntityRenderState)renderState;
            n = entityState.outlineColor;
        } else {
            n = 0;
        }
        renderTasks.submitBlock(poseStack, state, packedLight, OverlayTexture.NO_OVERLAY, n);
        poseStack.popPose();
    }

    public record RenderData<R extends GeoRenderState>(String boneName, ItemDisplayContext displayContext, BiFunction<GeoBone, R, Either<@NotNull ItemStack, @NotNull BlockState>> retrievalFunction) {
    }
}

