/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;

public class ItemInHandGeoLayer<T extends LivingEntity, O, R extends GeoRenderState>
extends BlockAndItemGeoLayer<T, O, R> {
    protected final String rightHandBone;
    protected final String leftHandBone;

    public ItemInHandGeoLayer(GeoRenderer<T, O, R> renderer) {
        this(renderer, "RightHandItem", "LeftHandItem");
    }

    public ItemInHandGeoLayer(GeoRenderer<T, O, R> renderer, String rightHandBoneName, String leftHandBoneName) {
        super(renderer);
        this.rightHandBone = rightHandBoneName;
        this.leftHandBone = leftHandBoneName;
    }

    @Override
    protected List<BlockAndItemGeoLayer.RenderData<R>> getRelevantBones(R renderState, BakedGeoModel model) {
        boolean isLeftHanded = renderState.getGeckolibData(DataTickets.IS_LEFT_HANDED);
        return List.of(ItemInHandGeoLayer.renderDataForHand(this.rightHandBone, HumanoidArm.RIGHT, isLeftHanded, renderState), ItemInHandGeoLayer.renderDataForHand(this.leftHandBone, HumanoidArm.LEFT, isLeftHanded, renderState));
    }

    protected static <R extends GeoRenderState> BlockAndItemGeoLayer.RenderData<R> renderDataForHand(String boneName, R renderState) {
        return ItemInHandGeoLayer.renderDataForHand(boneName, HumanoidArm.RIGHT, false, renderState);
    }

    protected static <R extends GeoRenderState> BlockAndItemGeoLayer.RenderData<R> renderDataForHand(String boneName, HumanoidArm arm, boolean isLeftHanded, R renderState) {
        HumanoidArm mainHandArm = isLeftHanded ? HumanoidArm.LEFT : HumanoidArm.RIGHT;
        EquipmentSlot slot = arm == mainHandArm ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        ItemDisplayContext context = switch (slot) {
            case EquipmentSlot.MAINHAND -> {
                if (mainHandArm == HumanoidArm.RIGHT) {
                    yield ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                }
                yield ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
            }
            case EquipmentSlot.OFFHAND -> {
                if (mainHandArm == HumanoidArm.RIGHT) {
                    yield ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                }
                yield ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
            }
            default -> ItemDisplayContext.NONE;
        };
        return new BlockAndItemGeoLayer.RenderData<GeoRenderState>(boneName, context, (bone, renderState2) -> Either.left((Object)((ItemStack)renderState2.getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).get(slot))));
    }

    @Override
    public void addRenderData(T animatable, O relatedObject, R renderState, float partialTick) {
        EnumMap<EquipmentSlot, ItemStack> equipment = renderState.getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(EquipmentSlot.class));
        equipment.put(EquipmentSlot.MAINHAND, animatable.getMainHandItem());
        equipment.put(EquipmentSlot.OFFHAND, animatable.getOffhandItem());
        renderState.addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        renderState.addGeckolibData(DataTickets.IS_LEFT_HANDED, animatable.getMainArm() == HumanoidArm.LEFT);
    }

    @Override
    protected void submitItemStackRender(PoseStack poseStack, GeoBone bone, ItemStack stack, ItemDisplayContext displayContext, R renderState, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
            poseStack.translate(0.0f, 0.125f, -0.0625f);
            if (stack.getItem() instanceof ShieldItem) {
                poseStack.translate(0.0, 0.125, -0.25);
            }
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
            poseStack.translate(0.0f, 0.125f, -0.0625f);
            if (stack.getItem() instanceof ShieldItem) {
                poseStack.translate(0.0, 0.125, 0.25);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            }
        }
        super.submitItemStackRender(poseStack, bone, stack, displayContext, renderState, renderTasks, cameraState, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }
}

