/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable;

import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animatable.manager.ContextAwareAnimatableManager;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.constant.DataTickets;

public interface GeoItem
extends SingletonGeoAnimatable {
    public static void registerSyncedAnimatable(SingletonGeoAnimatable animatable) {
        SingletonGeoAnimatable.registerSyncedAnimatable(animatable);
    }

    public static long getId(ItemStack stack) {
        return Optional.ofNullable(stack.getComponentsPatch().get(GeckoLibConstants.STACK_ANIMATABLE_ID_COMPONENT.get())).filter(Optional::isPresent).map(Optional::get).orElse(Long.MAX_VALUE);
    }

    public static long getOrAssignId(ItemStack stack, ServerLevel level) {
        DataComponentMap dataComponentMap = stack.getComponents();
        if (!(dataComponentMap instanceof PatchedDataComponentMap)) {
            return Long.MAX_VALUE;
        }
        PatchedDataComponentMap components = (PatchedDataComponentMap)dataComponentMap;
        Long id = (Long)components.get(GeckoLibConstants.STACK_ANIMATABLE_ID_COMPONENT.get());
        if (id == null) {
            id = AnimatableIdCache.getFreeId(level);
            components.set(GeckoLibConstants.STACK_ANIMATABLE_ID_COMPONENT.get(), (Object)id);
        }
        return id;
    }

    default public boolean isPerspectiveAware() {
        return false;
    }

    @Override
    default public @Nullable AnimatableInstanceCache animatableCacheOverride() {
        if (this.isPerspectiveAware()) {
            return new ContextBasedAnimatableInstanceCache(this);
        }
        return SingletonGeoAnimatable.super.animatableCacheOverride();
    }

    public static class ContextBasedAnimatableInstanceCache
    extends SingletonAnimatableInstanceCache {
        public ContextBasedAnimatableInstanceCache(GeoAnimatable animatable) {
            super(animatable);
        }

        public AnimatableManager<GeoItem> getManagerForId(long uniqueId) {
            if (!this.managers.containsKey(uniqueId)) {
                this.managers.put(uniqueId, (Object)new ContextAwareAnimatableManager<GeoItem, ItemDisplayContext>(this, this.animatable){

                    @Override
                    protected Map<ItemDisplayContext, AnimatableManager<GeoItem>> buildContextOptions(GeoAnimatable animatable) {
                        EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>> map = new EnumMap<ItemDisplayContext, AnimatableManager<GeoItem>>(ItemDisplayContext.class);
                        for (ItemDisplayContext context : ItemDisplayContext.values()) {
                            map.put(context, new AnimatableManager(animatable));
                        }
                        return map;
                    }

                    @Override
                    public ItemDisplayContext getCurrentContext() {
                        ItemDisplayContext context = this.getAnimatableData(DataTickets.ITEM_RENDER_PERSPECTIVE);
                        return context == null ? ItemDisplayContext.NONE : context;
                    }
                });
            }
            return (AnimatableManager)this.managers.get(uniqueId);
        }
    }
}

