/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.manager;

import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.dataticket.DataTicket;

public abstract class ContextAwareAnimatableManager<T extends GeoAnimatable, C>
extends AnimatableManager<T> {
    private final Map<C, AnimatableManager<T>> managers;

    @ApiStatus.Internal
    public ContextAwareAnimatableManager(GeoAnimatable animatable) {
        super(animatable);
        this.managers = this.buildContextOptions(animatable);
    }

    protected abstract Map<C, AnimatableManager<T>> buildContextOptions(GeoAnimatable var1);

    public abstract C getCurrentContext();

    public AnimatableManager<T> getManagerForContext(C context) {
        return this.managers.get(context);
    }

    @Override
    public Map<String, AnimationController<T>> getAnimationControllers() {
        return this.getManagerForContext(this.getCurrentContext()).getAnimationControllers();
    }

    @Override
    public void addController(AnimationController<T> controller) {
        this.getManagerForContext(this.getCurrentContext()).addController(controller);
    }

    @Override
    public void removeController(String name) {
        this.getManagerForContext(this.getCurrentContext()).removeController(name);
    }

    @Override
    public void tryTriggerAnimation(String animName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.tryTriggerAnimation(animName);
        }
    }

    @Override
    public void tryTriggerAnimation(String controllerName, String animName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.tryTriggerAnimation(controllerName, animName);
        }
    }

    @Override
    public void stopTriggeredAnimation(@Nullable String animName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.stopTriggeredAnimation(animName);
        }
    }

    @Override
    public void stopTriggeredAnimation(String controllerName, @Nullable String animName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.stopTriggeredAnimation(controllerName, animName);
        }
    }

    @Override
    public void markRenderedAt(double animatableTick) {
        super.markRenderedAt(animatableTick);
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.markRenderedAt(animatableTick);
        }
    }

    @Override
    public <D> void setAnimatableData(DataTicket<D> dataTicket, D data) {
        super.setAnimatableData(dataTicket, data);
    }

    @Override
    public <D> D getAnimatableData(DataTicket<D> dataTicket) {
        return super.getAnimatableData(dataTicket);
    }
}

