/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleMap;
import it.unimi.dsi.fastutil.objects.Reference2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.util.Mth;
import org.apache.logging.log4j.util.InternalApi;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.manager.AnimatableManager;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.object.EasingType;
import software.bernie.geckolib.animation.object.PlayState;
import software.bernie.geckolib.animation.state.AnimationPoint;
import software.bernie.geckolib.animation.state.AnimationTest;
import software.bernie.geckolib.animation.state.AnimationTimeline;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.animation.state.KeyFrameEvent;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.animation.keyframeevent.CustomInstructionKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.KeyFrameData;
import software.bernie.geckolib.cache.animation.keyframeevent.ParticleKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.SoundKeyframeData;
import software.bernie.geckolib.loading.math.MolangQueries;
import software.bernie.geckolib.loading.math.value.Variable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.MiscUtil;

public class AnimationController<T extends GeoAnimatable> {
    protected final String name;
    protected final AnimationStateHandler<T> stateHandler;
    protected final Supplier<Map<String, RawAnimation>> triggerableAnimations = Suppliers.memoize(Object2ObjectOpenHashMap::new);
    protected KeyframeEventHandler<T, SoundKeyframeData> soundKeyframeHandler = null;
    protected KeyframeEventHandler<T, ParticleKeyframeData> particleKeyframeHandler = null;
    protected KeyframeEventHandler<T, CustomInstructionKeyframeData> customKeyframeHandler = null;
    protected boolean additiveAnimations = false;
    protected int transitionTicks = 0;
    protected double animationSpeed = 1.0;
    protected boolean handlesTriggeredAnimations = false;
    @Nullable
    protected EasingType easingOverride = null;
    @Nullable
    protected AnimationTimeline timeline = null;
    protected PlayState playState = PlayState.STOP;
    @Nullable
    protected RawAnimation currentRawAnimation = null;
    @Nullable
    protected AnimationPoint transitionFromPoint = null;
    @Nullable
    protected AnimationPoint animationPoint = null;
    protected double timelineTime = -1.0;
    protected double lastAnimatableAge = 0.0;
    protected double triggeredAnimTime = -1.0;
    protected static final int NOT_TRIGGERED = -1;
    protected static final int NOT_ANIMATING = -1;
    protected static final int FINISHED_ANIMATING = -2;

    public AnimationController(AnimationStateHandler<T> stateHandler) {
        this("Default", 0, stateHandler);
    }

    public AnimationController(String name, AnimationStateHandler<T> stateHandler) {
        this(name, 0, stateHandler);
    }

    public AnimationController(String name, int transitionTicks, AnimationStateHandler<T> stateHandler) {
        this.name = name;
        this.stateHandler = stateHandler;
        this.transitionTicks = transitionTicks;
    }

    public String getName() {
        return this.name;
    }

    public PlayState getPlayState() {
        return this.playState;
    }

    public int getTransitionTicks() {
        return this.transitionTicks;
    }

    public double getAnimationSpeed() {
        return this.animationSpeed;
    }

    @Nullable
    public AnimationTimeline getTimeline() {
        return this.timeline;
    }

    public double getCurrentTimelineTime() {
        return this.timelineTime;
    }

    public double getCurrentAnimationTime() {
        return this.animationPoint == null ? 0.0 : this.animationPoint.animTime();
    }

    @Nullable
    public AnimationPoint getCurrentAnimationPoint() {
        return this.animationPoint;
    }

    @Nullable
    public RawAnimation getCurrentRawAnimation() {
        return this.currentRawAnimation;
    }

    public boolean isPlayingTriggeredAnimation() {
        return this.triggeredAnimTime >= 0.0 && this.isAnimatingBones();
    }

    public boolean hasAnimationFinished() {
        return this.animationPoint != null && this.animationPoint.hasFinished() && this.timeline != null && this.timelineTime >= this.timeline.lastAnimationEndTime();
    }

    public boolean isAnimatingBones() {
        return this.animationPoint != null && this.timeline != null && this.timelineTime >= 0.0;
    }

    public boolean isTransitioning() {
        return this.timeline != null && this.timelineTime >= 0.0 && this.timeline.getStage(this.timelineTime).isTransition();
    }

    public AnimationController<T> setSoundKeyframeHandler(KeyframeEventHandler<T, SoundKeyframeData> soundHandler) {
        this.soundKeyframeHandler = soundHandler;
        return this;
    }

    public AnimationController<T> setParticleKeyframeHandler(KeyframeEventHandler<T, ParticleKeyframeData> particleHandler) {
        this.particleKeyframeHandler = particleHandler;
        return this;
    }

    public AnimationController<T> setCustomInstructionKeyframeHandler(KeyframeEventHandler<T, CustomInstructionKeyframeData> customInstructionHandler) {
        this.customKeyframeHandler = customInstructionHandler;
        return this;
    }

    public AnimationController<T> setAnimationSpeed(double speed) {
        this.animationSpeed = speed;
        return this;
    }

    public AnimationController<T> setOverrideEasingType(EasingType easingType) {
        this.easingOverride = easingType;
        return this;
    }

    public AnimationController<T> additiveAnimations() {
        this.additiveAnimations = true;
        return this;
    }

    public AnimationController<T> receiveTriggeredAnimations() {
        this.handlesTriggeredAnimations = true;
        return this;
    }

    public AnimationController<T> triggerableAnim(String name, RawAnimation animation) {
        ((Map)this.triggerableAnimations.get()).put(name, animation);
        return this;
    }

    public void setAnimation(RawAnimation rawAnimation) {
        if (rawAnimation == null || rawAnimation.getStageCount() == 0) {
            GeckoLibConstants.LOGGER.warn("Tried to set an empty or null animation on controller {}!", (Object)this.name);
            return;
        }
        if (rawAnimation.equals(this.currentRawAnimation)) {
            return;
        }
        this.currentRawAnimation = rawAnimation;
        this.transitionFromPoint = this.animationPoint;
        this.animationPoint = null;
        this.triggeredAnimTime = -1.0;
    }

    public boolean triggerAnimation(String animName) {
        RawAnimation animation = (RawAnimation)((Map)this.triggerableAnimations.get()).get(animName);
        if (animation == null) {
            return false;
        }
        this.currentRawAnimation = animation;
        this.transitionFromPoint = this.animationPoint;
        this.triggeredAnimTime = ClientUtil.getCurrentTick();
        this.animationPoint = null;
        this.playState = PlayState.CONTINUE;
        return true;
    }

    public void setAnimationTime(double animTime) {
        if (animTime < 0.0) {
            throw new IllegalArgumentException("Attempting to set a negative animation time (" + animTime + ") on controller " + this.name + "?");
        }
        if (this.animationPoint == null || this.timeline == null || this.timelineTime < 0.0) {
            this.timelineTime = animTime + (double)((float)this.transitionTicks / 20.0f);
        } else {
            AnimationTimeline.Stage stage = this.timeline.getAnimationStage(this.timelineTime);
            if (stage.animation() != this.animationPoint.animation()) {
                stage = this.timeline.getAnimationStage(0.0);
            }
            this.timelineTime = Math.min(stage.startTime() + animTime, stage.endTime());
        }
    }

    public void setTimelineTime(double timelineTime) {
        this.timelineTime = timelineTime;
    }

    public boolean stopTriggeredAnimation() {
        if (this.triggeredAnimTime == -1.0) {
            return false;
        }
        this.triggeredAnimTime = -1.0;
        if (this.timeline == null || this.animationPoint == null || this.currentRawAnimation == null) {
            this.reset();
        } else {
            this.timelineTime = this.timeline.lastAnimationEndTime();
        }
        return true;
    }

    public void reset() {
        this.playState = PlayState.STOP;
        this.transitionFromPoint = null;
        this.animationPoint = null;
        this.timeline = null;
        this.currentRawAnimation = null;
        this.timelineTime = 0.0;
        this.triggeredAnimTime = -1.0;
    }

    @InternalApi
    @Nullable
    public ControllerState extractControllerState(T animatable, GeoRenderState renderState, AnimatableManager<T> manager, MolangQueries.Actor<T> actor, GeoModel<T> geoModel) {
        if (!this.checkControllerState(animatable, renderState, manager, geoModel)) {
            return null;
        }
        Reference2DoubleOpenHashMap queryValues = new Reference2DoubleOpenHashMap();
        MolangQueries.buildActorVariables(actor, this.getUsedVariables(), (Reference2DoubleMap<Variable>)queryValues);
        return new ControllerState(this.animationPoint, this.transitionFromPoint, this.timeline.getTransitionTime(this.timelineTime), this.timeline.getTransitionLength(), this.additiveAnimations, this.easingOverride, renderState, (Reference2DoubleMap<Variable>)queryValues);
    }

    @InternalApi
    protected boolean checkControllerState(T animatable, GeoRenderState renderState, AnimatableManager<T> manager, GeoModel<T> geoModel) {
        double timeDelta;
        boolean wasStopped = this.playState == PlayState.STOP;
        int transitionTicks = this.transitionTicks;
        RawAnimation prevRawAnimation = this.currentRawAnimation;
        double prevAnimationSpeed = this.animationSpeed;
        double prevTimelineTime = this.timelineTime;
        double d = timeDelta = this.playState == PlayState.PAUSE ? 0.0 : (renderState.getAnimatableAge() - this.lastAnimatableAge) / 20.0 * prevAnimationSpeed;
        this.timelineTime = this.timeline == null ? -1.0 : (this.timelineTime < 0.0 ? this.timelineTime : Mth.clamp((double)(this.timelineTime + timeDelta), (double)0.0, (double)this.timeline.totalTime()));
        this.lastAnimatableAge = renderState.getAnimatableAge();
        if (this.triggeredAnimTime == -1.0 || this.handlesTriggeredAnimations) {
            this.playState = this.stateHandler.handle(new AnimationTest<T>(animatable, renderState, manager, this));
        }
        if (this.playState != PlayState.STOP) {
            if (this.animationPoint == null || !Objects.equals(prevRawAnimation, this.currentRawAnimation)) {
                this.initializeNewAnimation(animatable, renderState, geoModel, prevAnimationSpeed, transitionTicks);
            } else if (this.timelineTime >= 0.0 || timeDelta < 0.0 == (this.timelineTime == -2.0)) {
                this.progressExistingAnimation(animatable, renderState, prevTimelineTime, timeDelta);
            }
        } else if (!wasStopped) {
            this.timelineTime = this.timeline == null ? -1.0 : this.timeline.lastAnimationEndTime();
        } else if (this.animationPoint != null && this.timeline != null && (this.timelineTime >= 0.0 || timeDelta < 0.0 == (this.timelineTime == -2.0))) {
            this.progressExistingAnimation(animatable, renderState, prevTimelineTime, timeDelta);
        }
        return this.isAnimatingBones();
    }

    @InternalApi
    protected void initializeNewAnimation(T animatable, GeoRenderState renderState, GeoModel<T> geoModel, double prevAnimSpeed, int prevTransitionTicks) {
        if (this.currentRawAnimation == null) {
            return;
        }
        double startTimeOffset = this.triggeredAnimTime >= 0.0 ? (ClientUtil.getCurrentTick() - this.triggeredAnimTime) * prevAnimSpeed : 0.0;
        this.timeline = AnimationTimeline.create(this.currentRawAnimation, animatable, geoModel, this.triggeredAnimTime > 0.0 ? prevTransitionTicks : this.transitionTicks);
        if (this.timeline == null) {
            return;
        }
        this.timelineTime = startTimeOffset;
        this.animationPoint = this.timeline.createAnimationPoint(this.timelineTime, this.animationPoint, this.easingOverride);
        if (startTimeOffset > 0.0) {
            this.timeline.triggerKeyframeMarkersBetween(animatable, renderState, 0.0, startTimeOffset, this, this.soundKeyframeHandler, this.particleKeyframeHandler, this.customKeyframeHandler);
        }
        this.validateKeyframeListeners(animatable);
    }

    @InternalApi
    protected void progressExistingAnimation(T animatable, GeoRenderState renderState, double prevTimelineTime, double timeAdvanced) {
        AnimationTimeline.Stage currentAnimStage;
        AnimationTimeline.Stage prevAnimStage;
        boolean isBacktracking;
        if (timeAdvanced == 0.0 || this.animationPoint == null || this.timeline == null) {
            return;
        }
        boolean bl = isBacktracking = timeAdvanced < 0.0;
        if (this.timelineTime < 0.0 && isBacktracking == (this.timelineTime == -2.0)) {
            double d = this.timelineTime = isBacktracking ? this.timeline.totalTime() : 0.0;
        }
        if ((prevAnimStage = this.timeline.getAnimationStage(prevTimelineTime)) != (currentAnimStage = this.timeline.getAnimationStage(this.timelineTime)) || MiscUtil.areFloatsEqual(currentAnimStage.endTime(), this.timelineTime)) {
            if (!isBacktracking && this.animationPoint.animation().loopType().shouldKeepPlaying((GeoAnimatable)animatable, this.animationPoint, prevAnimStage, renderState, this)) {
                this.timeline.triggerKeyframeMarkersBetween(animatable, renderState, prevTimelineTime, prevAnimStage.endTime(), this, this.soundKeyframeHandler, this.particleKeyframeHandler, this.customKeyframeHandler);
                this.animationPoint = this.timeline.createAnimationPoint(this.timelineTime, this.animationPoint, this.easingOverride);
                return;
            }
            this.transitionFromPoint = prevTimelineTime < this.timelineTime ? this.animationPoint : this.timeline.createAnimationPoint(currentAnimStage.endTime(), null, this.easingOverride);
        }
        this.timeline.triggerKeyframeMarkersBetween(animatable, renderState, prevTimelineTime, this.timelineTime, this, this.soundKeyframeHandler, this.particleKeyframeHandler, this.customKeyframeHandler);
        this.animationPoint = this.timeline.createAnimationPoint(this.timelineTime, this.animationPoint, this.easingOverride);
        if (timeAdvanced > 0.0 ? this.timelineTime >= this.timeline.totalTime() : this.timelineTime == 0.0) {
            this.timelineTime = isBacktracking ? -1.0 : -2.0;
        }
    }

    @InternalApi
    public Set<Variable> getUsedVariables() {
        if (this.animationPoint == null) {
            return Set.of();
        }
        ReferenceArraySet usedVariables = new ReferenceArraySet(this.animationPoint.animation().usedVariables());
        if (this.transitionFromPoint != null) {
            usedVariables.addAll(this.transitionFromPoint.animation().usedVariables());
        }
        return usedVariables;
    }

    @InternalApi
    public boolean isTriggeredAnimation(String animName) {
        return this.currentRawAnimation != null && this.currentRawAnimation.equals(((Map)this.triggerableAnimations.get()).get(animName));
    }

    @InternalApi
    private void validateKeyframeListeners(T animatable) {
        if (this.timeline == null) {
            return;
        }
        for (AnimationTimeline.Stage stage : this.timeline.stages()) {
            if (stage.animation() == null) continue;
            Animation animation = stage.animation();
            Animation.KeyframeMarkers markers = animation.keyframeMarkers();
            if (markers.customInstructions().length > 0 && this.customKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.warn("AnimationController {} for {} loaded animation {} with custom instruction keyframe markers, but no custom instruction handler has been set!", (Object)this.name, (Object)animatable.getClass().getName(), (Object)animation.name());
            }
            if (markers.sounds().length > 0 && this.soundKeyframeHandler == null) {
                GeckoLibConstants.LOGGER.warn("AnimationController {} for {} loaded animation {} with sound instruction keyframe markers, but no sound instruction handler has been set!", (Object)this.name, (Object)animatable.getClass().getName(), (Object)animation.name());
            }
            if (markers.particles().length <= 0 || this.particleKeyframeHandler != null) continue;
            GeckoLibConstants.LOGGER.warn("AnimationController {} for {} loaded animation {} with particle instruction keyframe markers, but no particle instruction handler has been set!", (Object)this.name, (Object)animatable.getClass().getName(), (Object)animation.name());
        }
    }

    @FunctionalInterface
    public static interface AnimationStateHandler<A extends GeoAnimatable> {
        public PlayState handle(AnimationTest<A> var1);
    }

    @FunctionalInterface
    public static interface KeyframeEventHandler<A extends GeoAnimatable, E extends KeyFrameData> {
        public void handle(KeyFrameEvent<A, E> var1);
    }
}

