/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.object;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.state.AnimationPoint;
import software.bernie.geckolib.animation.state.AnimationTimeline;
import software.bernie.geckolib.renderer.base.GeoRenderState;

@FunctionalInterface
public interface LoopType {
    public static final Map<String, LoopType> LOOP_TYPES = new ConcurrentHashMap<String, LoopType>(4);
    public static final LoopType DEFAULT = (animatable, animationPoint, timelineStage, renderState, controller) -> animationPoint.animation().loopType().shouldKeepPlaying(animatable, animationPoint, timelineStage, renderState, controller);
    public static final LoopType PLAY_ONCE = LoopType.register("play_once", LoopType.register("false", (animatable, animationPoint, timelineStage, renderState, controller) -> false));
    public static final LoopType HOLD_ON_LAST_FRAME = LoopType.register("hold_on_last_frame", (animatable, animationPoint, timelineStage, renderState, controller) -> {
        controller.setTimelineTime(timelineStage.endTime());
        return true;
    });
    public static final LoopType LOOP = LoopType.register("loop", LoopType.register("true", (animatable, animationPoint, timelineStage, renderState, controller) -> {
        controller.setTimelineTime(timelineStage.startTime() + (controller.getCurrentTimelineTime() - timelineStage.endTime()));
        return true;
    }));

    public boolean shouldKeepPlaying(GeoAnimatable var1, AnimationPoint var2, AnimationTimeline.Stage var3, GeoRenderState var4, AnimationController<? extends GeoAnimatable> var5);

    public static LoopType fromJson(JsonElement json) {
        if (json == null || !json.isJsonPrimitive()) {
            return PLAY_ONCE;
        }
        JsonPrimitive primitive = json.getAsJsonPrimitive();
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean() ? LOOP : PLAY_ONCE;
        }
        if (primitive.isString()) {
            return LoopType.fromString(primitive.getAsString());
        }
        return PLAY_ONCE;
    }

    default public String getId() throws IllegalStateException {
        for (String loopType : LOOP_TYPES.keySet()) {
            if (LOOP_TYPES.get(loopType) != this) continue;
            return loopType;
        }
        throw new IllegalStateException("LoopType has not been registered before being used!");
    }

    public static LoopType fromString(String name) {
        return LOOP_TYPES.getOrDefault(name, PLAY_ONCE);
    }

    public static LoopType register(String name, LoopType loopType) {
        LOOP_TYPES.put(name, loopType);
        return loopType;
    }
}

