/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.state;

import java.util.function.Function;
import net.minecraft.util.Mth;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animation.object.EasingType;
import software.bernie.geckolib.animation.object.LoopType;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.animation.BoneAnimation;
import software.bernie.geckolib.cache.animation.Keyframe;
import software.bernie.geckolib.cache.animation.KeyframeStack;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.util.MiscUtil;

public record AnimationPoint(Animation animation, @Nullable EasingType easingOverride, LoopType loopType, double animTime, int[][][] keyFramePoints) {
    public static final int NO_KEYFRAME = -2;
    public static final int BEFORE_FIRST_KEYFRAME = -1;

    public boolean hasFinished() {
        return MiscUtil.areFloatsEqual(this.animTime, this.animation.length());
    }

    public int[] scalePoints(int boneAnimationIndex) {
        return this.keyFramePoints[boneAnimationIndex][Transform.SCALE.index];
    }

    public int[] rotationPoints(int boneAnimationIndex) {
        return this.keyFramePoints[boneAnimationIndex][Transform.ROTATION.index];
    }

    public int[] translationPoints(int boneAnimationIndex) {
        return this.keyFramePoints[boneAnimationIndex][Transform.TRANSLATION.index];
    }

    public @Nullable Keyframe getPreviousKeyframe(int boneAnimationIndex, Transform transformationType, Axis axis) {
        return this.getKeyframe(boneAnimationIndex, transformationType, axis, -1);
    }

    public @Nullable Keyframe getCurrentKeyframe(int boneAnimationIndex, Transform transformationType, Axis axis) {
        return this.getKeyframe(boneAnimationIndex, transformationType, axis, 0);
    }

    public @Nullable Keyframe getNextKeyframe(int boneAnimationIndex, Transform transformationType, Axis axis) {
        return this.getKeyframe(boneAnimationIndex, transformationType, axis, 1);
    }

    public @Nullable Keyframe getKeyframe(int boneAnimationIndex, Transform transformationType, Axis axis, int keyframeOffset) {
        BoneAnimation boneAnimation = this.animation.boneAnimations()[boneAnimationIndex];
        Keyframe[] keyframes = axis.keyframes(transformationType.keyframeStack(boneAnimation));
        int keyframeIndex = this.keyFramePoints[boneAnimationIndex][transformationType.index][axis.index];
        return keyframes.length == 0 || keyframeIndex == -2 ? null : keyframes[Mth.clamp((int)(keyframeIndex + keyframeOffset), (int)0, (int)(keyframes.length - 1))];
    }

    public AnimationPoint createNext(double animTime) {
        if (MiscUtil.areFloatsEqual(animTime, this.animTime)) {
            return this;
        }
        animTime = Mth.clamp((double)animTime, (double)0.0, (double)this.animation.length());
        AnimationPoint animationPoint = new AnimationPoint(this.animation, this.easingOverride, this.loopType, animTime, this.keyFramePoints);
        boolean reverse = animTime < this.animTime;
        for (int i = 0; i < this.keyFramePoints.length; ++i) {
            AnimationPoint.findBonePoints(this.animation.boneAnimations()[i], animationPoint.keyFramePoints[i], animTime, reverse);
        }
        return animationPoint;
    }

    public int findBoneIndex(GeoBone bone) {
        BoneAnimation[] boneAnimations = this.animation.boneAnimations();
        for (int i = 0; i < boneAnimations.length; ++i) {
            if (!boneAnimations[i].boneName().equals(bone.name())) continue;
            return i;
        }
        return -1;
    }

    public static AnimationPoint createFor(Animation animation, @Nullable EasingType easingOverride, LoopType loopType, double animTime) {
        animTime = Mth.clamp((double)animTime, (double)0.0, (double)animation.length());
        return new AnimationPoint(animation, easingOverride, loopType, animTime, AnimationPoint.constructBoneArray(animation, animTime));
    }

    private static int[][][] constructBoneArray(Animation animation, double animTime) {
        BoneAnimation[] boneAnimations = animation.boneAnimations();
        int[][][] bones = new int[boneAnimations.length][3][3];
        for (int i = 0; i < boneAnimations.length; ++i) {
            AnimationPoint.findBonePoints(boneAnimations[i], bones[i], animTime, false);
        }
        return bones;
    }

    private static void findBonePoints(BoneAnimation boneAnimation, int[][] bonePoints, double animTime, boolean reverse) {
        AnimationPoint.findKeyframePoints(boneAnimation.scaleKeyFrames(), bonePoints[Transform.SCALE.index], animTime, reverse);
        AnimationPoint.findKeyframePoints(boneAnimation.rotationKeyFrames(), bonePoints[Transform.ROTATION.index], animTime, reverse);
        AnimationPoint.findKeyframePoints(boneAnimation.positionKeyFrames(), bonePoints[Transform.TRANSLATION.index], animTime, reverse);
    }

    private static void findKeyframePoints(KeyframeStack keyframeStack, int[] axisPoints, double animTime, boolean reverse) {
        if (reverse) {
            axisPoints[Axis.X.index] = AnimationPoint.findKeyframePointReverse(keyframeStack.xKeyframes(), animTime, axisPoints[Axis.X.index]);
            axisPoints[Axis.Y.index] = AnimationPoint.findKeyframePointReverse(keyframeStack.yKeyframes(), animTime, axisPoints[Axis.Y.index]);
            axisPoints[Axis.Z.index] = AnimationPoint.findKeyframePointReverse(keyframeStack.zKeyframes(), animTime, axisPoints[Axis.Z.index]);
        } else {
            axisPoints[Axis.X.index] = AnimationPoint.findKeyframePointForward(keyframeStack.xKeyframes(), animTime, axisPoints[Axis.X.index]);
            axisPoints[Axis.Y.index] = AnimationPoint.findKeyframePointForward(keyframeStack.yKeyframes(), animTime, axisPoints[Axis.Y.index]);
            axisPoints[Axis.Z.index] = AnimationPoint.findKeyframePointForward(keyframeStack.zKeyframes(), animTime, axisPoints[Axis.Z.index]);
        }
    }

    private static int findKeyframePointForward(Keyframe[] keyframes, double animTime, int startingIndex) {
        if (keyframes.length == 0) {
            return -2;
        }
        if (keyframes[0].startTime() > animTime) {
            return -1;
        }
        for (int i = Math.max(0, startingIndex); i < keyframes.length; ++i) {
            if (i + 1 >= keyframes.length || !(keyframes[i + 1].startTime() >= animTime)) continue;
            return i;
        }
        return keyframes.length - 1;
    }

    private static int findKeyframePointReverse(Keyframe[] keyframes, double animTime, int startingIndex) {
        if (keyframes.length == 0) {
            return -2;
        }
        for (int i = Math.min(startingIndex, keyframes.length - 1); i >= 0; --i) {
            if (i - 1 < 0 || !(keyframes[i - 1].startTime() <= animTime)) continue;
            return i - 1;
        }
        return -1;
    }

    public static enum Transform {
        SCALE(0, BoneAnimation::scaleKeyFrames),
        ROTATION(1, BoneAnimation::rotationKeyFrames),
        TRANSLATION(2, BoneAnimation::positionKeyFrames);

        public final int index;
        public final Function<BoneAnimation, KeyframeStack> stackFunction;

        private Transform(int index, Function<BoneAnimation, KeyframeStack> stackFunction) {
            this.index = index;
            this.stackFunction = stackFunction;
        }

        public KeyframeStack keyframeStack(BoneAnimation boneAnimation) {
            return this.stackFunction.apply(boneAnimation);
        }
    }

    public static enum Axis {
        X(0, KeyframeStack::xKeyframes),
        Y(1, KeyframeStack::yKeyframes),
        Z(2, KeyframeStack::zKeyframes);

        public final int index;
        public final Function<KeyframeStack, Keyframe[]> framesFunction;

        private Axis(int index, Function<KeyframeStack, Keyframe[]> framesFunction) {
            this.index = index;
            this.framesFunction = framesFunction;
        }

        public Keyframe[] keyframes(KeyframeStack stack) {
            return this.framesFunction.apply(stack);
        }
    }
}

