/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.state;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.animation.object.EasingType;
import software.bernie.geckolib.animation.object.LoopType;
import software.bernie.geckolib.animation.state.AnimationPoint;
import software.bernie.geckolib.animation.state.KeyFrameEvent;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.animation.keyframeevent.CustomInstructionKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.KeyFrameData;
import software.bernie.geckolib.cache.animation.keyframeevent.ParticleKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.SoundKeyframeData;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;

@ApiStatus.Internal
public record AnimationTimeline(Stage[] stages) {
    public double lastAnimationEndTime() {
        Stage stage = this.stages[this.stages.length - 1];
        return stage.isTransition ? stage.startTime : stage.endTime;
    }

    public double totalTime() {
        return this.stages[this.stages.length - 1].endTime;
    }

    public int getStageIndex(double timelineTime) {
        for (int i = 0; i < this.stages.length; ++i) {
            if (!(timelineTime < this.stages[i].endTime)) continue;
            return i;
        }
        return this.stages.length - 1;
    }

    public Stage getStage(double timelineTime) {
        return this.stages[this.getStageIndex(timelineTime)];
    }

    public int getTransitionLength() {
        return this.stages[0].isTransition ? Mth.ceil((double)this.stages[0].endTime) : 0;
    }

    public double getTransitionTime(double timelineTime) {
        Stage stage = this.getStage(timelineTime);
        return stage.isTransition ? timelineTime - stage.startTime : -1.0;
    }

    public Stage getAnimationStage(double timelineTime) {
        int stageIndex = this.getStageIndex(timelineTime);
        Stage stage = this.stages[stageIndex];
        if (!stage.isTransition) {
            return stage;
        }
        return stageIndex >= this.stages.length - 1 ? this.stages[stageIndex - 1] : this.stages[stageIndex + 1];
    }

    public boolean hasFinishedAnimations(double timelineTime) {
        return timelineTime >= this.lastAnimationEndTime();
    }

    public AnimationPoint createAnimationPoint(double timelineTime, @Nullable AnimationPoint existingPoint, @Nullable EasingType easingOverride) {
        double existingTime;
        int stageIndex = this.getStageIndex(timelineTime);
        Stage stage = this.stages[stageIndex];
        double time = timelineTime - stage.startTime;
        if (stage.isTransition) {
            boolean isReset = stageIndex >= this.stages.length - 1;
            stage = this.stages[isReset ? stageIndex - 1 : stageIndex + 1];
            time = isReset ? stage.endTime : stage.startTime;
        }
        double d = existingTime = existingPoint == null ? 0.0 : stage.startTime + existingPoint.animTime();
        if (existingPoint == null || existingPoint.animation() != stage.animation || this.totalTime() - existingTime < existingTime) {
            return AnimationPoint.createFor(stage.animation, easingOverride, stage.loopType(), time);
        }
        return existingPoint.createNext(time);
    }

    public <T extends GeoAnimatable> void triggerKeyframeMarkersBetween(T animatable, GeoRenderState renderState, double fromTime, double toTime, AnimationController<T> controller, @Nullable AnimationController.KeyframeEventHandler<T, SoundKeyframeData> soundHandler, @Nullable AnimationController.KeyframeEventHandler<T, ParticleKeyframeData> particleHandler, @Nullable AnimationController.KeyframeEventHandler<T, CustomInstructionKeyframeData> customInstructionHandler) {
        if (soundHandler == null && particleHandler == null && customInstructionHandler == null) {
            return;
        }
        ObjectArrayList soundMarkers = new ObjectArrayList();
        ObjectArrayList particleMarkers = new ObjectArrayList();
        ObjectArrayList customInstructionMarkers = new ObjectArrayList();
        double minTime = Math.min(fromTime, toTime);
        double maxTime = Math.max(fromTime, toTime);
        for (int i = 0; i < this.stages.length; ++i) {
            Stage stage = this.stages[i];
            if (stage.startTime > maxTime) {
                return;
            }
            if (!(stage.endTime > minTime) || stage.isTransition) continue;
            double animFromTime = Math.max(0.0, minTime - stage.startTime);
            double animToTime = Math.min(stage.animation.length(), maxTime - stage.startTime);
            if (soundHandler != null) {
                soundMarkers.addAll(this.getKeyframesForAnimation(animFromTime, animToTime, stage.animation.keyframeMarkers().sounds()));
            }
            if (particleHandler != null) {
                particleMarkers.addAll(this.getKeyframesForAnimation(animFromTime, animToTime, stage.animation.keyframeMarkers().particles()));
            }
            if (customInstructionHandler == null) continue;
            customInstructionMarkers.addAll(this.getKeyframesForAnimation(animFromTime, animToTime, stage.animation.keyframeMarkers().customInstructions()));
        }
        if (!soundMarkers.isEmpty()) {
            for (SoundKeyframeData soundData : toTime < fromTime ? soundMarkers.reversed() : soundMarkers) {
                soundHandler.handle(new KeyFrameEvent<T, SoundKeyframeData>(animatable, renderState, controller, soundData));
            }
        }
        if (!particleMarkers.isEmpty()) {
            for (ParticleKeyframeData particleData : toTime < fromTime ? particleMarkers.reversed() : particleMarkers) {
                particleHandler.handle(new KeyFrameEvent<T, ParticleKeyframeData>(animatable, renderState, controller, particleData));
            }
        }
        if (!customInstructionMarkers.isEmpty()) {
            for (CustomInstructionKeyframeData customData : toTime < fromTime ? customInstructionMarkers.reversed() : customInstructionMarkers) {
                customInstructionHandler.handle(new KeyFrameEvent<T, CustomInstructionKeyframeData>(animatable, renderState, controller, customData));
            }
        }
    }

    private <M extends KeyFrameData> List<M> getKeyframesForAnimation(double startTime, double endTime, M[] markers) {
        M marker;
        ObjectArrayList validMarkers = new ObjectArrayList();
        for (int i = 0; i < markers.length && !(((KeyFrameData)(marker = markers[i])).getTime() > endTime); ++i) {
            if (!(((KeyFrameData)marker).getTime() > startTime) && startTime != 0.0) continue;
            validMarkers.add(marker);
        }
        return validMarkers;
    }

    @Nullable
    public static <T extends GeoAnimatable> AnimationTimeline create(RawAnimation rawAnimation, T animatable, GeoModel<T> model, int transitionTicks) {
        List<RawAnimation.Stage> rawStages = rawAnimation.getAnimationStages();
        ObjectArrayList stages = new ObjectArrayList(rawStages.size());
        double transitionTime = (float)transitionTicks / 20.0f;
        double currentTime = 0.0;
        for (RawAnimation.Stage stage : rawStages) {
            Animation animation = AnimationProcessor.getOrCreateAnimation(stage, animatable, model);
            if (animation == null) continue;
            if (transitionTime > 0.0) {
                stages.add(Stage.transition(currentTime, transitionTime, animation));
                currentTime += transitionTime;
            }
            stages.add(Stage.animation(currentTime, animation, stage.loopType()));
            currentTime += animation.length();
        }
        if (stages.isEmpty()) {
            return null;
        }
        return new AnimationTimeline(stages.toArray(new Stage[0]));
    }

    public record Stage(double startTime, double endTime, boolean isTransition, @Nullable Animation animation, @Nullable LoopType loopType) {
        private static Stage transition(double startTime, double transitionTime, Animation animation) {
            return new Stage(startTime, startTime + transitionTime, true, animation, null);
        }

        private static Stage animation(double startTime, Animation animation, LoopType loopType) {
            return new Stage(startTime, startTime + animation.length(), false, animation, loopType);
        }
    }
}

