/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.state;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Quaternionfc;
import software.bernie.geckolib.cache.model.GeoBone;

public class BoneSnapshot {
    private final GeoBone bone;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private float translateX;
    private float translateY;
    private float translateZ;
    private float rotX;
    private float rotY;
    private float rotZ;
    private boolean skipRender = false;
    private boolean skipChildrenRender = false;

    protected BoneSnapshot(GeoBone bone) {
        this.bone = bone;
    }

    public static BoneSnapshot create(GeoBone bone) {
        return new BoneSnapshot(bone);
    }

    public GeoBone getBone() {
        return this.bone;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public float getScaleZ() {
        return this.scaleZ;
    }

    public float getTranslateX() {
        return this.translateX;
    }

    public float getTranslateY() {
        return this.translateY;
    }

    public float getTranslateZ() {
        return this.translateZ;
    }

    public float getRotX() {
        return this.rotX;
    }

    public float getRotY() {
        return this.rotY;
    }

    public float getRotZ() {
        return this.rotZ;
    }

    public boolean isHidden() {
        return this.skipRender;
    }

    public boolean areChildrenHidden() {
        return this.skipChildrenRender;
    }

    public boolean hasTranslation() {
        return this.translateX != 0.0f || this.translateY != 0.0f || this.translateZ != 0.0f;
    }

    public boolean hasRotation() {
        return this.rotX != 0.0f || this.rotY != 0.0f || this.rotZ != 0.0f;
    }

    public boolean hasScale() {
        return this.scaleX != 1.0f || this.scaleY != 1.0f || this.scaleZ != 1.0f;
    }

    public BoneSnapshot setScale(float x, float y, float z) {
        this.scaleX = x;
        this.scaleY = y;
        this.scaleZ = z;
        return this;
    }

    public BoneSnapshot setScaleX(float value) {
        this.scaleX = value;
        return this;
    }

    public BoneSnapshot setScaleY(float value) {
        this.scaleY = value;
        return this;
    }

    public BoneSnapshot setScaleZ(float value) {
        this.scaleZ = value;
        return this;
    }

    public BoneSnapshot setTranslation(float x, float y, float z) {
        this.translateX = x;
        this.translateY = y;
        this.translateZ = z;
        return this;
    }

    public BoneSnapshot setTranslateX(float value) {
        this.translateX = value;
        return this;
    }

    public BoneSnapshot setTranslateY(float value) {
        this.translateY = value;
        return this;
    }

    public BoneSnapshot setTranslateZ(float value) {
        this.translateZ = value;
        return this;
    }

    public BoneSnapshot setRotation(float x, float y, float z) {
        this.rotX = x;
        this.rotY = y;
        this.rotZ = z;
        return this;
    }

    public BoneSnapshot setRotX(float value) {
        this.rotX = value;
        return this;
    }

    public BoneSnapshot setRotY(float value) {
        this.rotY = value;
        return this;
    }

    public BoneSnapshot setRotZ(float value) {
        this.rotZ = value;
        return this;
    }

    public BoneSnapshot skipRender(boolean shouldSkip) {
        this.skipRender = shouldSkip;
        return this;
    }

    public BoneSnapshot skipChildrenRender(boolean shouldSkip) {
        this.skipChildrenRender = shouldSkip;
        return this;
    }

    public void scale(PoseStack poseStack) {
        if (this.hasScale()) {
            poseStack.scale(this.getScaleX(), this.getScaleY(), this.getScaleZ());
        }
    }

    public void rotate(PoseStack poseStack) {
        if (this.getRotZ() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(this.getRotZ()));
        }
        if (this.getRotY() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation(this.getRotY()));
        }
        if (this.getRotX() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotation(this.getRotX()));
        }
    }

    public void translate(PoseStack poseStack) {
        if (this.hasTranslation()) {
            poseStack.translate(-this.getTranslateX() / 16.0f, this.getTranslateY() / 16.0f, this.getTranslateZ() / 16.0f);
        }
    }

    @ApiStatus.Internal
    public void apply() {
        this.bone.frameSnapshot = this;
    }

    @ApiStatus.Internal
    public void cleanup() {
        this.bone.frameSnapshot = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.bone.name().equals(((BoneSnapshot)obj).bone.name());
    }

    public int hashCode() {
        return this.bone.name().hashCode();
    }
}

