/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import java.util.Map;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.loading.object.BakedAnimations;

public record BakedAnimationCache(Map<Identifier, BakedAnimations> cache) {
    @Nullable
    public Animation getAnimation(Identifier animationFile, Identifier[] fallbackFiles, String animationName) {
        BakedAnimations animations = null;
        for (int i = -1; i < fallbackFiles.length; ++i) {
            Animation animation;
            Identifier strippedPath;
            Identifier path = i == -1 ? animationFile : fallbackFiles[i];
            animations = this.cache.get(path);
            if (animations == null && !(strippedPath = BakedAnimationCache.stripLegacyPath(path)).equals((Object)path)) {
                GeckoLibConstants.LOGGER.error("Superfluous prefix or suffix found in animation resource path: '{}'. Should be '{}'", (Object)path, (Object)strippedPath);
                animationFile = BakedAnimationCache.stripLegacyPath(path);
                animations = this.cache.get(animationFile);
            }
            if (animations == null || (animation = animations.getAnimation(animationName)) == null) continue;
            return animation;
        }
        if (animations == null) {
            throw new IllegalArgumentException("Unable to find animation file '" + String.valueOf(animationFile) + "'");
        }
        GeckoLibConstants.LOGGER.error("Unable to find animation: '{}' in animation file '{}'", (Object)animationName, (Object)animationFile);
        return null;
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    private static Identifier stripLegacyPath(Identifier legacyPath) {
        String path = legacyPath.getPath();
        if (path.startsWith("geckolib/")) {
            path = path.substring(9);
        }
        if (path.startsWith("animations/")) {
            path = path.substring(11);
        }
        if (path.endsWith(".json")) {
            path = path.substring(0, path.length() - 5);
        }
        if (path.endsWith(".animations")) {
            path = path.substring(0, path.length() - 10);
        }
        return !path.equals(legacyPath.getPath()) ? legacyPath.withPath(path) : legacyPath;
    }
}

