/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.cache.BakedAnimationCache;
import software.bernie.geckolib.cache.BakedModelCache;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.loading.json.ModelFormatVersion;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.json.typeadapter.BakedAnimationsAdapter;
import software.bernie.geckolib.loading.json.typeadapter.KeyFramesAdapter;
import software.bernie.geckolib.loading.math.value.Constant;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.GeometryTree;
import software.bernie.geckolib.object.CompoundException;

public final class GeckoLibResources {
    public static final Identifier RELOAD_LISTENER_ID = GeckoLibConstants.id("geckolib_resources");
    public static final Identifier ANIMATIONS_PATH = GeckoLibConstants.id("geckolib/animations");
    public static final Identifier MODELS_PATH = GeckoLibConstants.id("geckolib/models");
    public static final Pattern SUFFIX_STRIPPER = Pattern.compile("((\\.geo)|((\\.animation)s?))?(\\.json)$");
    public static final Pattern PREFIX_STRIPPER = Pattern.compile("^(geckolib/)((animations/)|(models/))?");
    private static BakedAnimationCache ANIMATIONS = new BakedAnimationCache(Collections.emptyMap());
    private static BakedModelCache MODELS = new BakedModelCache(Collections.emptyMap());

    public static BakedAnimationCache getBakedAnimations() {
        return ANIMATIONS;
    }

    public static BakedModelCache getBakedModels() {
        return MODELS;
    }

    @ApiStatus.Internal
    public static CompletableFuture<Void> reload(PreparableReloadListener.SharedState sharedState, Executor prepExecutor, PreparableReloadListener.PreparationBarrier preparationBarrier, Executor applicationExecutor) {
        CompletableFuture<Map<Identifier, BakedAnimations>> animations = GeckoLibResources.loadAnimations(prepExecutor, sharedState.resourceManager());
        CompletableFuture<Map<Identifier, BakedGeoModel>> models = GeckoLibResources.loadModels(prepExecutor, sharedState.resourceManager());
        return CompletableFuture.runAsync(() -> {
            BakedAnimationsAdapter.COMPRESSION_CACHE = new ConcurrentHashMap<Double, Constant>();
        }, prepExecutor).thenCompose(ignored -> ((CompletableFuture)CompletableFuture.allOf(animations, models).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenRunAsync(() -> {
            ANIMATIONS = new BakedAnimationCache((Map)animations.join());
            MODELS = new BakedModelCache((Map)models.join());
            BakedAnimationsAdapter.COMPRESSION_CACHE = null;
        }, applicationExecutor));
    }

    public static Identifier stripPrefixAndSuffix(Identifier path) {
        String newPath = path.getPath();
        Matcher prefixMatcher = PREFIX_STRIPPER.matcher(newPath);
        newPath = prefixMatcher.find() ? newPath.substring(prefixMatcher.end()) : newPath;
        Matcher suffixMatcher = SUFFIX_STRIPPER.matcher(newPath);
        newPath = suffixMatcher.find() ? newPath.substring(0, suffixMatcher.start()) : newPath;
        return newPath.length() == path.getPath().length() ? path : path.withPath(newPath);
    }

    private static CompletableFuture<Map<Identifier, BakedAnimations>> loadAnimations(Executor backgroundExecutor, ResourceManager resourceManager) {
        return GeckoLibResources.bakeJsonResources(backgroundExecutor, resourceManager, ANIMATIONS_PATH.getPath(), GeckoLibResources::bakeAnimations, ex -> new BakedAnimations((Map<String, Animation>)new Object2ObjectOpenHashMap()));
    }

    private static CompletableFuture<Map<Identifier, BakedGeoModel>> loadModels(Executor backgroundExecutor, ResourceManager resourceManager) {
        return GeckoLibResources.bakeJsonResources(backgroundExecutor, resourceManager, MODELS_PATH.getPath(), GeckoLibResources::bakeModel, ex -> null);
    }

    private static <BAKED> CompletableFuture<Map<Identifier, BAKED>> bakeJsonResources(Executor backgroundExecutor, ResourceManager resourceManager, String assetPath, BiFunction<Identifier, JsonObject, BAKED> elementFactory, Function<Throwable, BAKED> exceptionalFactory) {
        return GeckoLibResources.loadResources(backgroundExecutor, resourceManager, assetPath, "json", GeckoLibResources::readJsonFile).thenCompose(resources -> {
            ObjectArrayList tasks = new ObjectArrayList(resources.size());
            resources.forEach(arg_0 -> GeckoLibResources.lambda$bakeJsonResources$7((List)tasks, elementFactory, backgroundExecutor, exceptionalFactory, arg_0));
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(arg_0 -> GeckoLibResources.lambda$bakeJsonResources$8((List)tasks, arg_0));
        });
    }

    private static <UNBAKED> CompletableFuture<List<Pair<Identifier, UNBAKED>>> loadResources(Executor executor, ResourceManager resourceManager, String assetPath, String fileType, BiFunction<Identifier, Resource, UNBAKED> elementFactory) {
        String fileTypeSuffix = "." + fileType;
        return CompletableFuture.supplyAsync(() -> resourceManager.listResources(assetPath, fileName -> fileName.getPath().endsWith(fileTypeSuffix)), executor).thenCompose(resources -> {
            ObjectArrayList tasks = new ObjectArrayList(resources.size());
            resources.forEach((arg_0, arg_1) -> GeckoLibResources.lambda$loadResources$13((List)tasks, elementFactory, executor, arg_0, arg_1));
            return CompletableFuture.allOf(tasks.toArray(new CompletableFuture[0])).thenApply(arg_0 -> GeckoLibResources.lambda$loadResources$14((List)tasks, arg_0));
        });
    }

    @NotNull
    private static BakedGeoModel bakeModel(Identifier path, JsonObject json) {
        if (path.getPath().endsWith(".animation.json")) {
            throw new RuntimeException("Found animation file found in models folder! '" + String.valueOf(path) + "'");
        }
        Model model = (Model)KeyFramesAdapter.GEO_GSON.fromJson((JsonElement)json, Model.class);
        ModelFormatVersion matchedVersion = ModelFormatVersion.match(model.formatVersion());
        if (matchedVersion == null) {
            GeckoLibConstants.LOGGER.warn("{}: Unknown geo model format version: '{}'. This may not work correctly", (Object)path, (Object)model.formatVersion());
        } else if (!matchedVersion.isSupported()) {
            GeckoLibConstants.LOGGER.error("{}: Unsupported geo model format version: '{}'. {}", (Object)path, (Object)model.formatVersion(), (Object)matchedVersion.getErrorMessage());
        }
        return BakedModelFactory.getForNamespace(path.getNamespace()).constructGeoModel(GeometryTree.fromModel(model));
    }

    @NotNull
    private static BakedAnimations bakeAnimations(Identifier path, JsonObject json) {
        if (path.getPath().endsWith(".geo.json")) {
            throw new RuntimeException("Found model file in animations folder! '" + String.valueOf(path) + "'");
        }
        try {
            return (BakedAnimations)KeyFramesAdapter.GEO_GSON.fromJson((JsonElement)GsonHelper.getAsJsonObject((JsonObject)json, (String)"animations"), BakedAnimations.class);
        }
        catch (CompoundException ex) {
            throw ex.withMessage(String.valueOf(path) + ": Error building animations from JSON");
        }
        catch (Exception ex) {
            throw GeckoLibConstants.exception(path, "Error building animations from JSON", ex);
        }
    }

    private static JsonObject readJsonFile(Identifier id, Resource resource) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = resource.openAsReader();
            try {
                jsonObject = GsonHelper.parse((Reader)reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw GeckoLibConstants.exception(id, "Error reading JSON file", ex);
                }
            }
            ((Reader)reader).close();
        }
        return jsonObject;
    }

    private static /* synthetic */ List lambda$loadResources$14(List tasks, Void ignored) {
        return tasks.stream().map(CompletableFuture::join).filter(Objects::nonNull).toList();
    }

    private static /* synthetic */ void lambda$loadResources$13(List tasks, BiFunction elementFactory, Executor executor, Identifier path, Resource resource) {
        tasks.add(CompletableFuture.supplyAsync(() -> Pair.of((Object)path, elementFactory.apply(path, resource)), executor));
    }

    private static /* synthetic */ Map lambda$bakeJsonResources$8(List tasks, Void ignored) {
        return tasks.stream().map(CompletableFuture::join).filter(Objects::nonNull).collect(Collectors.toMap(Pair::left, Pair::right));
    }

    private static /* synthetic */ void lambda$bakeJsonResources$7(List tasks, BiFunction elementFactory, Executor backgroundExecutor, Function exceptionalFactory, Pair pair) {
        tasks.add(CompletableFuture.supplyAsync(() -> Pair.of((Object)GeckoLibResources.stripPrefixAndSuffix((Identifier)pair.left()), elementFactory.apply((Identifier)pair.left(), (JsonObject)pair.right())), backgroundExecutor).exceptionally(ex -> {
            ex.printStackTrace();
            return Pair.of((Object)((Identifier)pair.left()), exceptionalFactory.apply(ex));
        }));
    }
}

