/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.animation;

import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animation.object.LoopType;
import software.bernie.geckolib.cache.animation.BoneAnimation;
import software.bernie.geckolib.cache.animation.keyframeevent.CustomInstructionKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.ParticleKeyframeData;
import software.bernie.geckolib.cache.animation.keyframeevent.SoundKeyframeData;
import software.bernie.geckolib.loading.math.value.Variable;

public record Animation(String name, double length, LoopType loopType, BoneAnimation[] boneAnimations, Set<Variable> usedVariables, KeyframeMarkers keyframeMarkers) {
    public static Animation create(String name, double length, LoopType loopType, BoneAnimation[] boneAnimations, KeyframeMarkers keyframeMarkers) {
        ReferenceOpenHashSet usedVariables = new ReferenceOpenHashSet();
        for (BoneAnimation boneAnimation : boneAnimations) {
            usedVariables.addAll(boneAnimation.getUsedVariables());
        }
        return new Animation(name, length, loopType, boneAnimations, (Set<Variable>)new ReferenceArraySet((Set)usedVariables), keyframeMarkers);
    }

    @ApiStatus.Internal
    public static Animation generateWaitAnimation(double length) {
        return new Animation("internal.wait", length, LoopType.PLAY_ONCE, new BoneAnimation[0], (Set<Variable>)ReferenceOpenHashSet.of(), new KeyframeMarkers(new SoundKeyframeData[0], new ParticleKeyframeData[0], new CustomInstructionKeyframeData[0]));
    }

    public record KeyframeMarkers(SoundKeyframeData[] sounds, ParticleKeyframeData[] particles, CustomInstructionKeyframeData[] customInstructions) {
        public boolean isEmpty() {
            return this.sounds.length == 0 && this.particles.length == 0 && this.customInstructions.length == 0;
        }
    }
}

