/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.loading.json.raw.ModelProperties;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.util.RenderUtil;

public record BakedGeoModel(GeoBone[] topLevelBones, ModelProperties properties, Supplier<Map<String, GeoBone>> boneLookup) {
    public BakedGeoModel(GeoBone[] topLevelBones, ModelProperties properties) {
        this(topLevelBones, properties, BakedGeoModel.createBoneMap(topLevelBones));
    }

    public Optional<GeoBone> getBone(String name) {
        return Optional.ofNullable(this.boneLookup.get().get(name));
    }

    public <R extends GeoRenderState> void render(RenderPassInfo<R> renderPassInfo, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        PoseStack poseStack = renderPassInfo.poseStack();
        for (GeoBone bone : this.topLevelBones()) {
            poseStack.pushPose();
            RenderUtil.prepMatrixForBone(poseStack, bone);
            bone.updateBonePositionListeners(poseStack, renderPassInfo);
            bone.render(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
            bone.renderChildren(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
            poseStack.popPose();
        }
    }

    private static Supplier<Map<String, GeoBone>> createBoneMap(GeoBone[] topLevelBones) {
        return Suppliers.memoize(() -> {
            Object2ReferenceOpenHashMap boneMap = new Object2ReferenceOpenHashMap();
            for (GeoBone bone : topLevelBones) {
                boneMap.put((Object)bone.name(), (Object)bone);
                for (GeoBone child : BakedGeoModel.collectChildBones(bone)) {
                    boneMap.put((Object)child.name(), (Object)child);
                }
            }
            return boneMap;
        });
    }

    private static List<GeoBone> collectChildBones(GeoBone bone) {
        ObjectArrayList bones = new ObjectArrayList();
        for (GeoBone child : bone.children()) {
            bones.add(child);
            bones.addAll(BakedGeoModel.collectChildBones(child));
        }
        return bones;
    }
}

