/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3fc;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.util.MiscUtil;
import software.bernie.geckolib.util.RenderUtil;

public abstract class GeoBone {
    @Nullable
    protected final GeoBone parent;
    protected final String name;
    protected final GeoBone[] children;
    protected final float pivotX;
    protected final float pivotY;
    protected final float pivotZ;
    protected final float baseRotX;
    protected final float baseRotY;
    protected final float baseRotZ;
    @Nullable
    @ApiStatus.Internal
    public BoneSnapshot frameSnapshot = null;
    @Nullable
    @ApiStatus.Internal
    public RenderPassInfo.BonePositionListener[] positionListeners = null;

    protected GeoBone(@Nullable GeoBone parent, String name, GeoBone[] children, float pivotX, float pivotY, float pivotZ, float rotX, float rotY, float rotZ) {
        this.parent = parent;
        this.name = name;
        this.children = children;
        this.pivotX = pivotX;
        this.pivotY = pivotY;
        this.pivotZ = pivotZ;
        this.baseRotX = rotX;
        this.baseRotY = rotY;
        this.baseRotZ = rotZ;
    }

    @Nullable
    public GeoBone parent() {
        return this.parent;
    }

    public String name() {
        return this.name;
    }

    public GeoBone[] children() {
        return this.children;
    }

    public float pivotX() {
        return this.pivotX;
    }

    public float pivotY() {
        return this.pivotY;
    }

    public float pivotZ() {
        return this.pivotZ;
    }

    public float baseRotX() {
        return this.baseRotX;
    }

    public float baseRotY() {
        return this.baseRotY;
    }

    public float baseRotZ() {
        return this.baseRotZ;
    }

    public abstract <R extends GeoRenderState> void render(RenderPassInfo<R> var1, PoseStack var2, VertexConsumer var3, int var4, int var5, int var6);

    public void renderChildren(RenderPassInfo<?> renderPassInfo, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        if (this.frameSnapshot == null || !this.frameSnapshot.areChildrenHidden()) {
            for (GeoBone child : this.children) {
                poseStack.pushPose();
                RenderUtil.prepMatrixForBone(poseStack, child);
                child.updateBonePositionListeners(poseStack, renderPassInfo);
                child.render(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
                child.renderChildren(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor);
                poseStack.popPose();
            }
        }
    }

    public void translateToPivotPoint(PoseStack poseStack) {
        poseStack.translate(this.pivotX() / 16.0f, this.pivotY() / 16.0f, this.pivotZ() / 16.0f);
    }

    public void translateAwayFromPivotPoint(PoseStack poseStack) {
        poseStack.translate(-this.pivotX() / 16.0f, -this.pivotY() / 16.0f, -this.pivotZ() / 16.0f);
    }

    @ApiStatus.Internal
    public void updateBonePositionListeners(PoseStack poseStack, RenderPassInfo<?> renderPassInfo) {
        if (this.positionListeners != null) {
            Matrix4f bonePose = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localPose = RenderUtil.extractPoseFromRoot((Matrix4fc)bonePose, renderPassInfo.getPreRenderMatrixState());
            Matrix4f modelPose = RenderUtil.extractPoseFromRoot((Matrix4fc)bonePose, renderPassInfo.getModelRenderMatrixState());
            Vec3 position = renderPassInfo.renderState().getOrDefaultGeckolibData(DataTickets.POSITION, null);
            Matrix4f worldPose = position == null ? null : new Matrix4f((Matrix4fc)modelPose).translate((Vector3fc)position.toVector3f());
            Vec3 localPos = RenderUtil.renderPoseToPosition((Matrix4fc)localPose, 1.0f, 1.0f, 1.0f);
            Vec3 modelPos = RenderUtil.renderPoseToPosition((Matrix4fc)modelPose, -16.0f, 16.0f, 16.0f);
            Vec3 worldPos = worldPose == null ? null : RenderUtil.renderPoseToPosition((Matrix4fc)worldPose, 1.0f, 1.0f, 1.0f);
            for (int i = 0; i < this.positionListeners.length; ++i) {
                this.positionListeners[i].accept(worldPos, modelPos, localPos);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GeoBone other = (GeoBone)obj;
        if (this.parent != other.parent) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!(MiscUtil.areFloatsEqual(this.pivotX, other.pivotX) && MiscUtil.areFloatsEqual(this.pivotY, other.pivotY) && MiscUtil.areFloatsEqual(this.pivotZ, other.pivotZ))) {
            return false;
        }
        return Arrays.equals(this.children, other.children);
    }

    public int hashCode() {
        return Objects.hash(this.parent == null ? "" : this.parent, this.name, Arrays.hashCode(this.children), Float.valueOf(this.pivotX), Float.valueOf(this.pivotY), Float.valueOf(this.pivotZ));
    }
}

