/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache.model.cuboid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.model.GeoQuad;
import software.bernie.geckolib.util.RenderUtil;

public record GeoCube(GeoQuad[] quads, Vec3 pivot, Vec3 rotation, Vec3 size) {
    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int renderColor) {
        this.translateToPivotPoint(poseStack);
        this.rotate(poseStack);
        this.translateAwayFromPivotPoint(poseStack);
        Matrix3f normalisedPoseState = poseStack.last().normal();
        Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
        for (GeoQuad quad : this.quads) {
            if (quad == null) continue;
            Vector3f normal = normalisedPoseState.transform(quad.normalVec());
            RenderUtil.fixInvertedFlatCube(this, normal);
            quad.render(poseState, normal, vertexConsumer, packedLight, packedOverlay, renderColor);
        }
    }

    public void rotate(PoseStack poseStack) {
        Vec3 rotation = this.rotation();
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.z()));
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationXYZ(0.0f, (float)rotation.y(), 0.0f));
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotationXYZ((float)rotation.x(), 0.0f, 0.0f));
    }

    public void translateToPivotPoint(PoseStack poseStack) {
        poseStack.translate(this.pivot().x() / 16.0, this.pivot().y() / 16.0, this.pivot().z() / 16.0);
    }

    public void translateAwayFromPivotPoint(PoseStack poseStack) {
        poseStack.translate(-this.pivot().x() / 16.0, -this.pivot().y() / 16.0, -this.pivot().z() / 16.0);
    }
}

