/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.loading.math.function.round;

import net.minecraft.util.Mth;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.loading.math.MathValue;
import software.bernie.geckolib.loading.math.function.MathFunction;

public final class LerpFunction
extends MathFunction {
    private final MathValue min;
    private final MathValue max;
    private final MathValue delta;

    public LerpFunction(MathValue ... values) {
        super(values);
        this.min = values[0];
        this.max = values[1];
        this.delta = values[2];
    }

    @Override
    public String getName() {
        return "math.lerp";
    }

    @Override
    public double compute(ControllerState controllerState) {
        return Mth.lerp((double)this.delta.get(controllerState), (double)this.min.get(controllerState), (double)this.max.get(controllerState));
    }

    @Override
    public int getMinArgs() {
        return 3;
    }

    @Override
    public MathValue[] getArgs() {
        return new MathValue[]{this.min, this.max, this.delta};
    }
}

