/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.mixin.client;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.dataticket.DataTicket;
import software.bernie.geckolib.renderer.base.GeoRenderState;

@Mixin(value={BlockEntityRenderState.class})
public class BlockEntityRenderStateMixin
implements GeoRenderState {
    @Shadow
    public int lightCoords;
    @Unique
    private final Map<DataTicket<?>, Object> geckolib$data = new Reference2ObjectOpenHashMap();

    @Override
    @Unique
    public <D> void addGeckolibData(DataTicket<D> dataTicket, @Nullable D data) {
        this.geckolib$data.put(dataTicket, data);
    }

    @Override
    @Unique
    public boolean hasGeckolibData(DataTicket<?> dataTicket) {
        return this.geckolib$data.containsKey(dataTicket);
    }

    @Override
    @Unique
    public int getPackedLight() {
        return this.getOrDefaultGeckolibData(DataTickets.PACKED_LIGHT, this.lightCoords);
    }

    @Override
    @Unique
    @Nullable
    public <D> D getGeckolibData(DataTicket<D> dataTicket) {
        Object data = this.geckolib$data.get(dataTicket);
        if (data == null && !this.hasGeckolibData(dataTicket)) {
            throw new IllegalArgumentException("Attempted to retrieve data from GeoRenderState that does not exist. Check your code!");
        }
        try {
            return (D)data;
        }
        catch (ClassCastException ex) {
            GeckoLibConstants.LOGGER.error("Attempted to retrieve incorrectly typed data from GeoRenderState. Possibly a mod or DataTicket conflict? Expected: {}, found data type {}", dataTicket, (Object)data.getClass().getName(), (Object)ex);
            throw ex;
        }
    }

    @Override
    @Unique
    @Nullable
    public <D> D getOrDefaultGeckolibData(DataTicket<D> dataTicket, @Nullable D defaultValue) {
        Object data = this.geckolib$data.get(dataTicket);
        if (data == null && !this.hasGeckolibData(dataTicket)) {
            return defaultValue;
        }
        try {
            return (D)data;
        }
        catch (ClassCastException ex) {
            GeckoLibConstants.LOGGER.error("Attempted to retrieve incorrectly typed data from GeoRenderState. Possibly a mod or DataTicket conflict? Expected: {}, found data type {}", dataTicket, (Object)data.getClass().getName(), (Object)ex);
            return defaultValue;
        }
    }

    @Override
    @ApiStatus.Internal
    public Map<DataTicket<?>, Object> getDataMap() {
        return this.geckolib$data;
    }
}

