/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import net.minecraft.resources.Identifier;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class DefaultedGeoModel<T extends GeoAnimatable>
extends GeoModel<T> {
    private Identifier modelPath;
    private Identifier texturePath;
    private Identifier animationsPath;

    public DefaultedGeoModel(Identifier assetSubpath) {
        this.modelPath = this.buildFormattedModelPath(assetSubpath);
        this.texturePath = this.buildFormattedTexturePath(assetSubpath);
        this.animationsPath = this.buildFormattedAnimationPath(assetSubpath);
    }

    public DefaultedGeoModel<T> withAltModel(Identifier altPath) {
        this.modelPath = this.buildFormattedModelPath(altPath);
        return this;
    }

    public DefaultedGeoModel<T> withAltAnimations(Identifier altPath) {
        this.animationsPath = this.buildFormattedAnimationPath(altPath);
        return this;
    }

    public DefaultedGeoModel<T> withAltTexture(Identifier altPath) {
        this.texturePath = this.buildFormattedTexturePath(altPath);
        return this;
    }

    public Identifier buildFormattedModelPath(Identifier basePath) {
        return basePath.withPrefix(this.subtype() + "/");
    }

    public Identifier buildFormattedAnimationPath(Identifier basePath) {
        return basePath.withPrefix(this.subtype() + "/");
    }

    public Identifier buildFormattedTexturePath(Identifier basePath) {
        return basePath.withPath("textures/" + this.subtype() + "/" + basePath.getPath() + ".png");
    }

    protected abstract String subtype();

    @Override
    public Identifier getModelResource(GeoRenderState renderState) {
        return this.modelPath;
    }

    @Override
    public Identifier getTextureResource(GeoRenderState renderState) {
        return this.texturePath;
    }

    @Override
    public Identifier getAnimationResource(T animatable) {
        return this.animationsPath;
    }
}

