/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.model;

import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.GeckoLibResources;
import software.bernie.geckolib.cache.animation.Animation;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;

public abstract class GeoModel<T extends GeoAnimatable> {
    public abstract Identifier getModelResource(GeoRenderState var1);

    public abstract Identifier getTextureResource(GeoRenderState var1);

    public abstract Identifier getAnimationResource(T var1);

    public Identifier[] getAnimationResourceFallbacks(T animatable) {
        return new Identifier[0];
    }

    public void addAdditionalStateData(T animatable, Object relatedObject, GeoRenderState renderState) {
    }

    @ApiStatus.Internal
    public BakedGeoModel getBakedModel(Identifier location) {
        return GeckoLibResources.getBakedModels().getModel(location);
    }

    @ApiStatus.Internal
    @Nullable
    public Animation getBakedAnimation(T animatable, String name) throws RuntimeException {
        Identifier animationFile = this.getAnimationResource(animatable);
        Identifier[] fallbackFiles = this.getAnimationResourceFallbacks(animatable);
        return GeckoLibResources.getBakedAnimations().getAnimation(animationFile, fallbackFiles, name);
    }
}

