/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet.blockentity;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.constant.dataticket.SerializableDataTicket;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.ClientUtil;

public record BlockEntityDataSyncPacket<D>(BlockPos pos, SerializableDataTicket<D> dataTicket, D data) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<BlockEntityDataSyncPacket<?>> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("blockentity_data_sync"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BlockEntityDataSyncPacket<?>> CODEC = StreamCodec.of((buf, packet) -> {
        SerializableDataTicket.STREAM_CODEC.encode(buf, packet.dataTicket);
        buf.writeBlockPos(packet.pos);
        packet.dataTicket.streamCodec().encode(buf, packet.data);
    }, buf -> {
        SerializableDataTicket dataTicket = (SerializableDataTicket)SerializableDataTicket.STREAM_CODEC.decode(buf);
        return new BlockEntityDataSyncPacket<Object>(buf.readBlockPos(), dataTicket, dataTicket.streamCodec().decode(buf));
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            BlockEntity patt0$temp = ClientUtil.getLevel().getBlockEntity(this.pos);
            if (patt0$temp instanceof GeoBlockEntity) {
                GeoBlockEntity blockEntity = (GeoBlockEntity)patt0$temp;
                blockEntity.setAnimData(this.dataTicket, this.data);
            }
        });
    }
}

