/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.object;

import java.util.function.Function;

public class DeferredCache<I, O> {
    private I input;
    private O output = null;
    private boolean computed = false;
    private final Function<I, O> mappingFunction;

    public DeferredCache(I input, Function<I, O> mappingFunction) {
        this.input = input;
        this.mappingFunction = mappingFunction;
    }

    public I getInput() {
        if (this.computed) {
            throw new IllegalStateException("Attempting to access input after output of deferred cache has been calculated!");
        }
        return this.input;
    }

    public O getOutput() {
        if (!this.computed) {
            throw new IllegalStateException("Attempting to access output before it has been calculated!");
        }
        return this.output;
    }

    public O compute() {
        if (!this.computed) {
            this.output = this.mappingFunction.apply(this.input);
            this.input = null;
            this.computed = true;
        }
        return this.getOutput();
    }
}

