/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;

public class GeoArmorRenderer<T extends Item, R extends HumanoidRenderState>
implements GeoRenderer<T, RenderData, R> {
    protected static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    protected final GeoRenderLayersContainer<T, RenderData, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public <I extends T> GeoArmorRenderer(I armorItem) {
        this(new DefaultedGeoModel<T>(BuiltInRegistries.ITEM.getKey(armorItem)){

            @Override
            protected String subtype() {
                return "armor";
            }
        });
    }

    public GeoArmorRenderer(GeoModel<T> model) {
        this.model = model;
    }

    public List<ArmorSegment> getSegmentsForSlot(R renderState, EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> List.of(ArmorSegment.HEAD);
            case EquipmentSlot.CHEST -> List.of(ArmorSegment.CHEST, ArmorSegment.LEFT_ARM, ArmorSegment.RIGHT_ARM);
            case EquipmentSlot.LEGS -> List.of(ArmorSegment.LEFT_LEG, ArmorSegment.RIGHT_LEG);
            case EquipmentSlot.FEET -> List.of(ArmorSegment.LEFT_FOOT, ArmorSegment.RIGHT_FOOT);
            default -> List.of();
        };
    }

    public String getBoneNameForSegment(R renderState, ArmorSegment segment) {
        return switch (segment.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "armorHead";
            case 1 -> "armorBody";
            case 2 -> "armorLeftArm";
            case 3 -> "armorRightArm";
            case 4 -> "armorLeftLeg";
            case 5 -> "armorRightLeg";
            case 6 -> "armorLeftBoot";
            case 7 -> "armorRightBoot";
        };
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, RenderData, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoArmorRenderer<T, R> withRenderLayer(Function<? super GeoArmorRenderer<T, R>, GeoRenderLayer<T, RenderData, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoArmorRenderer<T, R> withRenderLayer(GeoRenderLayer<T, RenderData, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoArmorRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoArmorRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public int getRenderColor(T animatable, RenderData stackAndSlot, float partialTick) {
        return GeckoLibServices.Client.ITEM_RENDERING.getDyedItemColor(stackAndSlot.itemStack(), -1);
    }

    @Override
    @Nullable
    public RenderType getRenderType(R renderState, Identifier texture) {
        return RenderTypes.armorCutoutNoCull((Identifier)texture);
    }

    @Override
    @ApiStatus.OverrideOnly
    public long getInstanceId(T animatable, RenderData stackAndSlot) {
        long stackId = GeoItem.getId(stackAndSlot.itemStack());
        if (stackId == Long.MAX_VALUE) {
            int id = stackAndSlot.entity().getId() * 13;
            return (long)id * (long)id * (long)id * (long)(-(stackAndSlot.slot().ordinal() + 1));
        }
        return -stackId;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @ApiStatus.Internal
    public void captureDefaultRenderState(T animatable, RenderData renderData, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, renderData, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.TICK, Double.valueOf(renderState.ageInTicks));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.POSITION, renderData.entity().position());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_GECKOLIB_WEARER, renderData.entity() instanceof GeoAnimatable);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.EQUIPMENT_SLOT, renderData.slot());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.HAS_GLINT, renderData.itemStack().hasFoil());
        v0 = (GeoRenderState)renderState;
        if (!(renderState instanceof LivingEntityRenderState)) ** GOTO lbl-1000
        livingRenderState = renderState;
        if (livingRenderState.isInvisibleToPlayer) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        v0.addGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, v1);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.HUMANOID_MODEL, renderData.baseModel);
    }

    @Override
    public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        GeoRenderer.super.scaleModelForRender(renderPassInfo, this.scaleWidth * widthScale, this.scaleHeight * heightScale);
    }

    @Override
    public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
        renderPassInfo.poseStack().translate(0.0f, 1.5f, 0.0f);
        renderPassInfo.poseStack().scale(-1.0f, -1.0f, 1.0f);
    }

    @Override
    public void submitRenderTasks(RenderPassInfo<R> renderPassInfo, OrderedSubmitNodeCollector renderTasks, @Nullable RenderType renderType) {
        if (renderType == null) {
            return;
        }
        int packedLight = renderPassInfo.packedLight();
        int packedOverlay = renderPassInfo.packedOverlay();
        int renderColor = renderPassInfo.renderColor();
        renderTasks.submitCustomGeometry(renderPassInfo.poseStack(), renderType, (pose, vertexConsumer) -> {
            PoseStack poseStack = renderPassInfo.poseStack();
            HumanoidRenderState renderState = (HumanoidRenderState)renderPassInfo.renderState();
            EquipmentSlot slot = ((GeoRenderState)renderState).getGeckolibData(DataTickets.EQUIPMENT_SLOT);
            HumanoidModel baseModel = ((GeoRenderState)renderState).getGeckolibData(DataTickets.HUMANOID_MODEL);
            BakedGeoModel bakedModel = renderPassInfo.model();
            renderPassInfo.addBoneUpdater((renderPassInfo1, snapshots) -> {
                List<ArmorSegment> segments = this.getSegmentsForSlot(renderState, slot);
                if (!segments.isEmpty()) {
                    baseModel.setupAnim(renderState);
                    for (ArmorSegment segment : this.getSegmentsForSlot(renderState, slot)) {
                        snapshots.get(this.getBoneNameForSegment(renderState, segment)).ifPresent(snapshot -> {
                            ModelPart modelPart = segment.modelPartGetter.apply(baseModel);
                            Vector3f bonePos = (Vector3f)segment.modelPartMatcher.apply(new Vector3f(modelPart.x, modelPart.y, modelPart.z));
                            snapshot.setRotX(-modelPart.xRot).setRotY(-modelPart.yRot).setRotZ(modelPart.zRot).setTranslateX(bonePos.x).setTranslateY(bonePos.y).setTranslateZ(bonePos.z);
                        });
                    }
                }
            });
            poseStack.pushPose();
            poseStack.last().set(pose);
            renderPassInfo.renderPosed(() -> {
                for (ArmorSegment segment : this.getSegmentsForSlot(renderState, slot)) {
                    bakedModel.getBone(this.getBoneNameForSegment(renderState, segment)).ifPresent(bone -> bone.render(renderPassInfo, poseStack, vertexConsumer, packedLight, packedOverlay, renderColor));
                }
                renderPassInfo.model().render(renderPassInfo, vertexConsumer, packedLight, packedOverlay, renderColor);
            });
            poseStack.popPose();
        });
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, RenderData relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileArmorRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        return GeckoLibServices.Client.EVENTS.fireArmorPreRender(renderPassInfo, renderTasks);
    }

    @ApiStatus.Internal
    public static <R extends HumanoidRenderState, A extends HumanoidModel<R>> boolean tryRenderGeoArmorPiece(BiFunction<R, EquipmentSlot, A> modelFunction, PoseStack poseStack, SubmitNodeCollector renderTasks, ItemStack stack, EquipmentSlot slot, int packedLight, R entityRenderState) {
        StackForRender stackForRender = StackForRender.find(stack, slot, entityRenderState, modelFunction);
        if (stackForRender == null || !(entityRenderState instanceof GeoRenderState)) {
            return false;
        }
        R geoRenderState = entityRenderState;
        EnumMap perSlotData = geoRenderState.getOrDefaultGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, null);
        if (perSlotData == null || !perSlotData.containsKey(slot)) {
            return false;
        }
        HumanoidRenderState perSlotRenderState = (HumanoidRenderState)perSlotData.get(slot);
        stackForRender.renderer.performRenderPass((GeoRenderState)perSlotRenderState, poseStack, renderTasks, Minecraft.getInstance().levelRenderer.levelRenderState.cameraRenderState, null);
        return true;
    }

    @ApiStatus.Internal
    public static <R extends HumanoidRenderState, A extends HumanoidModel<R>> void captureRenderStates(R baseRenderState, LivingEntity entity, float partialTick, BiFunction<R, EquipmentSlot, A> modelFunction, Function<EquipmentSlot, R> renderStateSupplier) {
        List<StackForRender> relevantSlots = GeoArmorRenderer.getRelevantSlotsForRendering(entity, baseRenderState, modelFunction);
        if (relevantSlots == null) {
            return;
        }
        EnumMap<EquipmentSlot, HumanoidRenderState> slotRenderData = new EnumMap<EquipmentSlot, HumanoidRenderState>(EquipmentSlot.class);
        for (StackForRender entry : relevantSlots) {
            RenderData renderData = new RenderData(entry.stack, entry.slot, entity, entry.baseModel);
            HumanoidRenderState slotRenderState = (HumanoidRenderState)renderStateSupplier.apply(entry.slot);
            entry.renderer.fillRenderState((GeoAnimatable)entry.stack.getItem(), renderData, (GeoRenderState)slotRenderState, partialTick);
            slotRenderData.put(entry.slot, slotRenderState);
        }
        ((GeoRenderState)baseRenderState).addGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, slotRenderData);
    }

    @Nullable
    @ApiStatus.Internal
    private static <R extends HumanoidRenderState, A extends HumanoidModel<R>> List<StackForRender> getRelevantSlotsForRendering(LivingEntity entity, R entityRenderState, BiFunction<R, EquipmentSlot, A> modelFunction) {
        List relevantSlots = null;
        for (int i = 0; i < ARMOR_SLOTS.length; ++i) {
            EquipmentSlot slot = ARMOR_SLOTS[i];
            StackForRender stackForRender = StackForRender.find(entity.getItemBySlot(slot), slot, entityRenderState, modelFunction);
            if (stackForRender == null) continue;
            if (relevantSlots == null) {
                relevantSlots = new ObjectArrayList(ARMOR_SLOTS.length - i);
            }
            relevantSlots.add(stackForRender);
        }
        return relevantSlots;
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public R createRenderState(T animatable, RenderData relatedObject) {
        return (R)new HumanoidRenderState();
    }

    public static enum ArmorSegment {
        HEAD(EquipmentSlot.HEAD, model -> model.head, pos -> pos.mul(1.0f, -1.0f, 1.0f)),
        CHEST(EquipmentSlot.CHEST, model -> model.body, pos -> pos.mul(1.0f, -1.0f, 1.0f)),
        LEFT_ARM(EquipmentSlot.CHEST, model -> model.leftArm, pos -> pos.set(pos.x - 5.0f, 2.0f - pos.y, pos.z)),
        RIGHT_ARM(EquipmentSlot.CHEST, model -> model.rightArm, pos -> pos.set(pos.x + 5.0f, 2.0f - pos.y, pos.z)),
        LEFT_LEG(EquipmentSlot.LEGS, model -> model.leftLeg, pos -> pos.set(pos.x - 2.0f, 12.0f - pos.y, pos.z)),
        RIGHT_LEG(EquipmentSlot.LEGS, model -> model.rightLeg, pos -> pos.set(pos.x + 2.0f, 12.0f - pos.y, pos.z)),
        LEFT_FOOT(EquipmentSlot.FEET, model -> model.leftLeg, pos -> pos.set(pos.x - 2.0f, 12.0f - pos.y, pos.z)),
        RIGHT_FOOT(EquipmentSlot.FEET, model -> model.rightLeg, pos -> pos.set(pos.x + 2.0f, 12.0f - pos.y, pos.z));

        public final EquipmentSlot equipmentSlot;
        public final Function<HumanoidModel<?>, ModelPart> modelPartGetter;
        public final UnaryOperator<Vector3f> modelPartMatcher;

        private ArmorSegment(EquipmentSlot slot, Function<HumanoidModel<?>, ModelPart> modelPartGetter, UnaryOperator<Vector3f> modelPartMatcher) {
            this.equipmentSlot = slot;
            this.modelPartGetter = modelPartGetter;
            this.modelPartMatcher = modelPartMatcher;
        }
    }

    public record RenderData(ItemStack itemStack, EquipmentSlot slot, LivingEntity entity, HumanoidModel<?> baseModel) {
    }

    @ApiStatus.Internal
    private record StackForRender(ItemStack stack, EquipmentSlot slot, GeoArmorRenderer renderer, HumanoidModel<?> baseModel) {
        @Nullable
        private static <S extends HumanoidRenderState, A extends HumanoidModel<S>> StackForRender find(ItemStack stack, EquipmentSlot slot, S entityRenderState, BiFunction<S, EquipmentSlot, A> modelFunction) {
            GeoRenderProvider geckolibRenderers;
            Equippable equippable = (Equippable)stack.get(DataComponents.EQUIPPABLE);
            if (equippable == null || !HumanoidArmorLayer.shouldRender((Equippable)equippable, (EquipmentSlot)slot) || (geckolibRenderers = GeoRenderProvider.of(stack)) == GeoRenderProvider.DEFAULT) {
                return null;
            }
            HumanoidModel baseModel = (HumanoidModel)modelFunction.apply(entityRenderState, slot);
            GeoArmorRenderer<?, ?> armorRenderer = geckolibRenderers.getGeoArmorRenderer(stack, slot);
            if (armorRenderer == null) {
                return null;
            }
            return new StackForRender(stack, slot, armorRenderer, baseModel);
        }
    }
}

