/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;

public class GeoBlockRenderer<T extends BlockEntity, R extends BlockEntityRenderState>
implements GeoRenderer<T, Void, R>,
BlockEntityRenderer<T, R> {
    protected final GeoRenderLayersContainer<T, Void, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoBlockRenderer(BlockEntityType<? extends T> blockEntityType) {
        this(new DefaultedBlockGeoModel(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType)));
    }

    public GeoBlockRenderer(GeoModel<T> model) {
        this.model = model;
    }

    protected Direction getBlockStateDirection(T blockEntity) {
        BlockState blockState = blockEntity.getBlockState();
        for (EnumProperty property : new EnumProperty[]{BlockStateProperties.FACING, BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.VERTICAL_DIRECTION, BlockStateProperties.FACING_HOPPER}) {
            if (!blockState.hasProperty((Property)property)) continue;
            return (Direction)blockState.getValue((Property)property);
        }
        return Direction.NORTH;
    }

    protected void tryRotateByBlockstate(RenderPassInfo<R> renderPassInfo, PoseStack poseStack) {
        Direction facing = renderPassInfo.getGeckolibData(DataTickets.BLOCK_FACING);
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
                break;
            }
        }
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoBlockRenderer<T, R> withRenderLayer(Function<? super GeoBlockRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoBlockRenderer<T, R> withRenderLayer(GeoRenderLayer<T, Void, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoBlockRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoBlockRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.OverrideOnly
    public long getInstanceId(T animatable, Void ignored) {
        return animatable.getBlockPos().hashCode();
    }

    @Override
    @ApiStatus.Internal
    public void captureDefaultRenderState(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCKSTATE, animatable.getBlockState());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.POSITION, Vec3.atCenterOf((Vec3i)animatable.getBlockPos()));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCK_FACING, this.getBlockStateDirection(animatable));
    }

    @Override
    public void preRenderPass(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        renderPassInfo.poseStack().translate(0.5, 0.0, 0.5);
    }

    @Override
    public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        GeoRenderer.super.scaleModelForRender(renderPassInfo, this.scaleWidth * widthScale, this.scaleHeight * heightScale);
    }

    @Override
    public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
        this.tryRotateByBlockstate(renderPassInfo, renderPassInfo.poseStack());
    }

    @ApiStatus.Internal
    public void submit(R renderState, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraRenderState) {
        GeoRenderer.super.performRenderPass(renderState, poseStack, renderTasks, cameraRenderState);
    }

    @ApiStatus.Internal
    public R createRenderState() {
        return (R)new BlockEntityRenderState();
    }

    public void extractRenderState(T blockEntity, R renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay damageOverlayState) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, damageOverlayState);
        this.fillRenderState(blockEntity, null, renderState, partialTick);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        return GeckoLibServices.Client.EVENTS.fireBlockPreRender(renderPassInfo, renderTasks);
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public final R createRenderState(T animatable, Void relatedObject) {
        return (R)new BlockEntityRenderState();
    }
}

