/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;

public class GeoObjectRenderer<T extends GeoAnimatable, E, R extends GeoRenderState>
implements GeoRenderer<T, E, R> {
    protected final GeoRenderLayersContainer<T, E, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoObjectRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        GeoRenderer.super.scaleModelForRender(renderPassInfo, this.scaleWidth * widthScale, this.scaleHeight * heightScale);
    }

    @Override
    public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
        renderPassInfo.poseStack().translate(0.5f, 0.51f, 0.5f);
    }

    public void performRenderPass(T animatable, E relatedObject, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int partialTick) {
        this.performRenderPass(animatable, relatedObject, poseStack, renderTasks, cameraState, packedLight, partialTick, null);
    }

    public void performRenderPass(T animatable, E relatedObject, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int partialTick, @Nullable RenderPassInfo.BoneUpdater<R> boneUpdater) {
        R renderState = this.fillRenderState(animatable, relatedObject, this.createRenderState(animatable, (E)null), partialTick);
        renderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        GeoRenderer.super.performRenderPass(renderState, poseStack, renderTasks, cameraState, boneUpdater);
    }

    @Override
    public R createRenderState(T animatable, E relatedObject) {
        return (R)new GeoRenderState.Impl();
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, E, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoObjectRenderer<T, E, R> withRenderLayer(Function<? super GeoObjectRenderer<T, E, R>, GeoRenderLayer<T, E, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoObjectRenderer<T, E, R> withRenderLayer(GeoRenderLayer<T, E, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoObjectRenderer<T, E, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoObjectRenderer<T, E, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileObjectRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, @Nullable E relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileObjectRenderState(this, renderState, animatable, relatedObject);
    }

    @Override
    public boolean firePreRenderEvent(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        return GeckoLibServices.Client.EVENTS.fireObjectPreRender(renderPassInfo, renderTasks);
    }
}

