/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRendererInternals;
import software.bernie.geckolib.renderer.internal.BoneSnapshots;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;

public interface GeoRenderer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRendererInternals<T, O, R> {
    @Override
    default public int getRenderColor(T animatable, O relatedObject, float partialTick) {
        return -1;
    }

    @Override
    default public int getPackedOverlay(T animatable, O relatedObject, float u, float partialTick) {
        return OverlayTexture.NO_OVERLAY;
    }

    default public float getMotionAnimThreshold(T animatable) {
        return 0.015f;
    }

    default public @Nullable RenderType getRenderType(R renderState, Identifier texture) {
        return RenderTypes.entityCutoutNoCull((Identifier)texture);
    }

    @Override
    @ApiStatus.OverrideOnly
    default public void addRenderData(T animatable, O relatedObject, R renderState, float partialTick) {
    }

    @Override
    default public void setMolangQueryValues(T animatable, O relatedObject, R renderState, float partialTick) {
    }

    default public void performRenderPass(R renderState, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraState) {
        this.performRenderPass(renderState, poseStack, renderTasks, cameraState, null);
    }

    default public void performRenderPass(R renderState, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraState, @Nullable RenderPassInfo.BoneUpdater<R> boneUpdater) {
        poseStack.pushPose();
        RenderType renderType = this.getRenderType(renderState, this.getTextureLocation(renderState));
        RenderPassInfo<R> renderPassInfo = RenderPassInfo.create(this, renderState, poseStack, cameraState, renderType != null);
        if (boneUpdater != null) {
            renderPassInfo.addBoneUpdater(boneUpdater);
        }
        if (this.firePreRenderEvent(renderPassInfo, renderTasks)) {
            this.preRenderPass(renderPassInfo, renderTasks);
            this.scaleModelForRender(renderPassInfo, 1.0f, 1.0f);
            this.adjustRenderPose(renderPassInfo);
            this.preApplyRenderLayers(renderPassInfo, renderTasks);
            renderPassInfo.captureModelRenderPose();
            this.submitRenderTasks(renderPassInfo, (OrderedSubmitNodeCollector)renderTasks, renderType);
            this.submitPerBoneRenderTasks(renderPassInfo, renderTasks);
            this.applyRenderLayers(renderPassInfo, renderTasks);
        }
        poseStack.popPose();
        this.postRenderPass(renderPassInfo, renderTasks);
    }

    default public void preRenderPass(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
    }

    default public void scaleModelForRender(RenderPassInfo<R> renderPassInfo, float widthScale, float heightScale) {
        if (widthScale != 1.0f || heightScale != 1.0f) {
            renderPassInfo.poseStack().scale(widthScale, heightScale, widthScale);
        }
    }

    default public void adjustRenderPose(RenderPassInfo<R> renderPassInfo) {
    }

    default public void adjustModelBonesForRender(RenderPassInfo<R> renderPassInfo, BoneSnapshots snapshots) {
    }

    default public void submitRenderTasks(RenderPassInfo<R> renderPassInfo, OrderedSubmitNodeCollector renderTasks, @Nullable RenderType renderType) {
        if (renderType == null) {
            return;
        }
        int packedLight = renderPassInfo.packedLight();
        int packedOverlay = renderPassInfo.packedOverlay();
        int renderColor = renderPassInfo.renderColor();
        renderTasks.submitCustomGeometry(renderPassInfo.poseStack(), renderType, (pose, vertexConsumer) -> {
            PoseStack poseStack = renderPassInfo.poseStack();
            poseStack.pushPose();
            poseStack.last().set(pose);
            renderPassInfo.renderPosed(() -> renderPassInfo.model().render(renderPassInfo, vertexConsumer, packedLight, packedOverlay, renderColor));
            poseStack.popPose();
        });
    }

    default public void postRenderPass(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
    }
}

