/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.base;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationProcessor;
import software.bernie.geckolib.animation.state.ControllerState;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.BoneSnapshots;
import software.bernie.geckolib.renderer.internal.PerBoneRender;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public sealed interface GeoRendererInternals<T extends GeoAnimatable, O, R extends GeoRenderState>
permits GeoRenderer {
    public GeoModel<T> getGeoModel();

    default public List<GeoRenderLayer<T, O, R>> getRenderLayers() {
        return List.of();
    }

    public int getRenderColor(T var1, O var2, float var3);

    public int getPackedOverlay(T var1, O var2, float var3, float var4);

    @ApiStatus.OverrideOnly
    default public long getInstanceId(T animatable, O relatedObject) {
        return animatable.hashCode();
    }

    default public Identifier getTextureLocation(R renderState) {
        return this.getGeoModel().getTextureResource((GeoRenderState)renderState);
    }

    @ApiStatus.Internal
    default public void captureDefaultRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        long instanceId = this.getInstanceId(animatable, relatedObject);
        renderState.addGeckolibData(DataTickets.TICK, ClientUtil.getCurrentTick());
        renderState.addGeckolibData(DataTickets.ANIMATABLE_INSTANCE_ID, instanceId);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_MANAGER, animatable.getAnimatableInstanceCache().getManagerForId(instanceId));
        renderState.addGeckolibData(DataTickets.PARTIAL_TICK, (Float)Float.valueOf(partialTick));
        renderState.addGeckolibData(DataTickets.RENDER_COLOR, this.getRenderColor(animatable, relatedObject, partialTick));
        renderState.addGeckolibData(DataTickets.PACKED_OVERLAY, this.getPackedOverlay(animatable, relatedObject, 0.0f, partialTick));
        renderState.addGeckolibData(DataTickets.IS_MOVING, false);
        renderState.addGeckolibData(DataTickets.ANIMATABLE_CLASS, animatable.getClass());
    }

    public R createRenderState(T var1, O var2);

    @ApiStatus.OverrideOnly
    public void addRenderData(T var1, O var2, R var3, float var4);

    public void setMolangQueryValues(T var1, O var2, R var3, float var4);

    @ApiStatus.NonExtendable
    default public R fillRenderState(T animatable, O relatedObject, R renderState, float partialTick) {
        this.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        this.addRenderData(animatable, relatedObject, renderState, partialTick);
        this.getGeoModel().addAdditionalStateData(animatable, relatedObject, (GeoRenderState)renderState);
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.addRenderData(animatable, relatedObject, renderState, partialTick);
        }
        this.fireCompileRenderStateEvent(animatable, relatedObject, renderState, partialTick);
        this.setMolangQueryValues(animatable, relatedObject, renderState, partialTick);
        AnimationProcessor.extractControllerStates(animatable, renderState, this.getGeoModel());
        return renderState;
    }

    default public void preApplyRenderLayers(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.preRender(renderPassInfo, renderTasks);
            renderLayer.addPerBoneRender(renderPassInfo, renderPassInfo::addPerBoneRender);
        }
    }

    default public void applyRenderLayers(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        for (GeoRenderLayer<T, O, R> renderLayer : this.getRenderLayers()) {
            renderLayer.submitRenderTask(renderPassInfo, renderTasks);
        }
    }

    default public void applyAnimationControllers(RenderPassInfo<R> renderPassInfo, BoneSnapshots boneSnapshots) {
        ControllerState[] controllerStates = renderPassInfo.getGeckolibData(DataTickets.ANIMATION_CONTROLLER_STATES);
        for (int i = 0; i < controllerStates.length; ++i) {
            AnimationProcessor.createBoneSnapshots(controllerStates[i], boneSnapshots);
        }
    }

    default public void submitPerBoneRenderTasks(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        Map perBoneRenders = renderPassInfo.getBoneRenderTasks();
        if (perBoneRenders.isEmpty()) {
            return;
        }
        renderPassInfo.renderPosed(() -> {
            Matrix4f pose = renderPassInfo.getModelRenderMatrixState();
            PoseStack poseStack = renderPassInfo.poseStack();
            poseStack.pushPose();
            poseStack.last().pose().set((Matrix4fc)pose);
            for (Map.Entry boneTasks : perBoneRenders.entrySet()) {
                GeoBone bone = (GeoBone)boneTasks.getKey();
                poseStack.pushPose();
                RenderUtil.transformToBone(poseStack, bone);
                for (PerBoneRender renderOp : (List)boneTasks.getValue()) {
                    poseStack.pushPose();
                    renderOp.submitRenderTask(renderPassInfo, bone, renderTasks);
                    poseStack.popPose();
                }
                poseStack.popPose();
            }
            poseStack.popPose();
        });
    }

    public void fireCompileRenderLayersEvent();

    public void fireCompileRenderStateEvent(T var1, O var2, R var3, float var4);

    public boolean firePreRenderEvent(RenderPassInfo<R> var1, SubmitNodeCollector var2);
}

