/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.internal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;

@ApiStatus.Internal
public class GeckolibItemSpecialRenderer<T extends Item>
implements SpecialModelRenderer<RenderData<T>> {
    public void submit(@Nullable RenderData<T> renderData, ItemDisplayContext itemDisplayContext, PoseStack poseStack, SubmitNodeCollector renderTasks, int packedLight, int packedOverlay, boolean hasGlint, int outlineColor) {
        if (renderData == null) {
            return;
        }
        renderData.renderState.addGeckolibData(DataTickets.HAS_GLINT, hasGlint);
        renderData.renderState.addGeckolibData(DataTickets.PACKED_OVERLAY, packedOverlay);
        renderData.renderState.addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
        renderData.renderer.submit(renderData.renderState, poseStack, renderTasks, outlineColor);
    }

    public void getExtents(Consumer<Vector3fc> consumer) {
        consumer.accept((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public RenderData<T> extractArgument(ItemStack itemStack, ItemStackRenderState renderState, ItemDisplayContext context, @Nullable ClientLevel level, @Nullable ItemOwner itemOwner) {
        T item = this.makeCovariantItem(itemStack.getItem());
        GeoItemRenderer<?> renderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (renderer == null) {
            return null;
        }
        return new RenderData<T>(item, this.buildRenderState(item, itemStack, renderer, renderState, context, level, itemOwner), renderer);
    }

    @Deprecated
    @Nullable
    public RenderData<T> extractArgument(ItemStack itemStack) {
        return this.extractArgument(itemStack, new ItemStackRenderState(), ItemDisplayContext.FIXED, null, null);
    }

    private T makeCovariantItem(Item item) {
        return (T)(item instanceof GeoAnimatable ? item : null);
    }

    private GeoRenderState buildRenderState(T animatable, ItemStack itemStack, GeoItemRenderer<T> renderer, ItemStackRenderState renderState, ItemDisplayContext context, @Nullable ClientLevel level, @Nullable ItemOwner itemOwner) {
        GeoItemRenderer.RenderData renderData = new GeoItemRenderer.RenderData(itemStack, renderState, context, level, itemOwner);
        return renderer.fillRenderState(animatable, renderData, renderer.createRenderState(animatable, renderData), Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true));
    }

    public record RenderData<T extends Item>(T item, GeoRenderState renderState, GeoItemRenderer<T> renderer) {
    }

    public static class Unbaked
    implements SpecialModelRenderer.Unbaked {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit(Unbaked::new);

        @Nullable
        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new GeckolibItemSpecialRenderer();
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

