/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.TextureLayerGeoLayer;
import software.bernie.geckolib.util.RenderUtil;

public class AutoGlowingGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends TextureLayerGeoLayer<T, O, R> {
    private final Map<Identifier, Identifier> emissiveResourceCache = new Object2ObjectOpenHashMap();
    protected static final RenderPipeline RENDER_PIPELINE = RenderPipelines.register((RenderPipeline)EmissiveRenderType.createRenderPipeline());

    public AutoGlowingGeoLayer(GeoRenderer<T, O, R> renderer) {
        super(renderer);
    }

    @Override
    protected Identifier getTextureResource(R renderState) {
        return this.emissiveResourceCache.computeIfAbsent(this.renderer.getTextureLocation(renderState), RenderUtil::getEmissiveResource);
    }

    protected boolean shouldRespectWorldLighting(R renderState) {
        return false;
    }

    protected boolean shouldAddZOffset(R renderState) {
        return this.getRenderer() instanceof GeoArmorRenderer;
    }

    protected int getBrightness(R renderState) {
        return 0xF00000;
    }

    @Override
    @Nullable
    protected RenderType getRenderType(R renderState) {
        Identifier texture = this.getTextureResource(renderState);
        boolean respectLighting = this.shouldRespectWorldLighting(renderState);
        boolean zOffset = this.shouldAddZOffset(renderState);
        if (!(renderState instanceof EntityRenderState)) {
            return EmissiveRenderType.getRenderType(texture, false, respectLighting, zOffset);
        }
        EntityRenderState entityRenderState = (EntityRenderState)renderState;
        boolean invisible = entityRenderState.isInvisible;
        if (invisible && !renderState.getOrDefaultGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, false).booleanValue()) {
            return RenderTypes.itemEntityTranslucentCull((Identifier)texture);
        }
        if (entityRenderState.appearsGlowing()) {
            if (invisible) {
                return RenderTypes.outline((Identifier)texture);
            }
            return EmissiveRenderType.getRenderType(texture, true, respectLighting, zOffset);
        }
        return invisible ? null : EmissiveRenderType.getRenderType(texture, false, respectLighting, zOffset);
    }

    @Override
    public void submitRenderTask(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        int packedLight = renderPassInfo.packedLight();
        renderPassInfo.renderState().addGeckolibData(DataTickets.PACKED_LIGHT, this.getBrightness(renderPassInfo.renderState()));
        super.submitRenderTask(renderPassInfo, renderTasks);
        renderPassInfo.renderState().addGeckolibData(DataTickets.PACKED_LIGHT, packedLight);
    }

    public static class EmissiveRenderType {
        private static final Map<Entry, RenderType> CACHE = new ConcurrentHashMap<Entry, RenderType>();

        public static RenderType getRenderType(Identifier texture, boolean outline, boolean respectLighting, boolean zOffset) {
            return CACHE.computeIfAbsent(new Entry(texture, outline, respectLighting, zOffset), EmissiveRenderType::buildNewInstance);
        }

        private static RenderPipeline createRenderPipeline() {
            return RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.MATRICES_FOG_LIGHT_DIR_SNIPPET}).withLocation(GeckoLibConstants.id("pipeline/emissive")).withVertexShader("core/entity").withFragmentShader("core/entity").withShaderDefine("EMISSIVE").withShaderDefine("NO_OVERLAY").withShaderDefine("NO_CARDINAL_LIGHTING").withSampler("Sampler0").withBlend(BlendFunction.TRANSLUCENT).withDepthWrite(false).withCull(false).withVertexFormat(DefaultVertexFormat.NEW_ENTITY, VertexFormat.Mode.QUADS).build();
        }

        private static RenderType buildNewInstance(Entry entry) {
            RenderSetup.RenderSetupBuilder builder = RenderSetup.builder((RenderPipeline)RENDER_PIPELINE).withTexture("Sampler0", entry.texture).setLayeringTransform(entry.zOffset ? LayeringTransform.VIEW_OFFSET_Z_LAYERING : LayeringTransform.NO_LAYERING).setOutline(entry.outline ? RenderSetup.OutlineProperty.AFFECTS_OUTLINE : RenderSetup.OutlineProperty.NONE).sortOnUpload();
            if (entry.respectLighting) {
                return RenderType.create((String)"geckolib_entity_translucent_emissive", (RenderSetup)builder.useOverlay().affectsCrumbling().createRenderSetup());
            }
            return RenderType.create((String)"geckolib_emissive", (RenderSetup)builder.createRenderSetup());
        }

        public record Entry(Identifier texture, boolean outline, boolean respectLighting, boolean zOffset) {
            @Override
            public int hashCode() {
                return Objects.hash(this.texture, this.outline, this.respectLighting, this.zOffset);
            }
        }
    }
}

