/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import java.util.function.BiConsumer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.ApiStatus;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.PerBoneRender;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;

public abstract class GeoRenderLayer<T extends GeoAnimatable, O, R extends GeoRenderState> {
    protected final GeoRenderer<T, O, R> renderer;

    public GeoRenderLayer(GeoRenderer<T, O, R> renderer) {
        this.renderer = renderer;
    }

    public GeoModel<T> getGeoModel() {
        return this.renderer.getGeoModel();
    }

    public BakedGeoModel getDefaultBakedModel(GeoRenderState renderState) {
        return this.getGeoModel().getBakedModel(this.getGeoModel().getModelResource(renderState));
    }

    public GeoRenderer<T, O, R> getRenderer() {
        return this.renderer;
    }

    protected Identifier getTextureResource(R renderState) {
        return this.renderer.getTextureLocation(renderState);
    }

    @ApiStatus.OverrideOnly
    public void addRenderData(T animatable, O relatedObject, R renderState, float partialTick) {
    }

    public void preRender(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
    }

    public void submitRenderTask(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
    }

    public void addPerBoneRender(RenderPassInfo<R> renderPassInfo, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
    }
}

