/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.EnumMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.object.equipment.ElytraModel;
import net.minecraft.client.model.object.skull.SkullModelBase;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.resources.model.EquipmentAssetManager;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Util;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animation.state.BoneSnapshot;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.cache.model.cuboid.CuboidGeoBone;
import software.bernie.geckolib.cache.model.cuboid.GeoCube;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.PerBoneRender;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.service.GeckoLibClient;
import software.bernie.geckolib.util.RenderStateUtil;
import software.bernie.geckolib.util.RenderUtil;

public abstract class ItemArmorGeoLayer<T extends LivingEntity, O, R extends EntityRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final EquipmentLayerRenderer equipmentRenderer;
    protected final EquipmentAssetManager equipmentAssets;
    protected final Function<SkullBlock.Type, SkullModelBase> skullModels;
    protected final PlayerSkinRenderCache skinCache;

    public ItemArmorGeoLayer(GeoRenderer<T, O, R> geoRenderer, EntityRendererProvider.Context context) {
        super(geoRenderer);
        this.equipmentRenderer = context.getEquipmentRenderer();
        this.equipmentAssets = context.getEquipmentAssets();
        this.skullModels = Util.memoize(type -> SkullBlockRenderer.createModel((EntityModelSet)context.getModelSet(), (SkullBlock.Type)type));
        this.skinCache = context.getPlayerSkinRenderCache();
    }

    protected abstract List<RenderData> getRelevantBones(RenderPassInfo<R> var1);

    @Override
    public void addRenderData(T animatable, O relatedObject, R renderState, float partialTick) {
        EnumMap<EquipmentSlot, ItemStack> equipment = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, new EnumMap(EquipmentSlot.class));
        this.collectArmorData(renderState, animatable, partialTick, equipment);
        if (!equipment.get(EquipmentSlot.CHEST).isEmpty()) {
            ((GeoRenderState)renderState).addGeckolibData(DataTickets.ELYTRA_ROTATION, new Vec3((double)((LivingEntity)animatable).elytraAnimationState.getRotX(partialTick), (double)((LivingEntity)animatable).elytraAnimationState.getRotY(partialTick), (double)((LivingEntity)animatable).elytraAnimationState.getRotZ(partialTick)));
        }
    }

    protected <S extends HumanoidRenderState, A extends HumanoidModel<S>> void collectArmorData(R baseRenderState, T animatable, float partialTick, EnumMap<EquipmentSlot, ItemStack> equipment) {
        Object headRenderState = this.getOrCreateHumanoidRenderState(baseRenderState, false);
        ((HumanoidRenderState)headRenderState).headEquipment = animatable.getItemBySlot(EquipmentSlot.HEAD);
        equipment.put(EquipmentSlot.HEAD, ((HumanoidRenderState)headRenderState).headEquipment);
        ((HumanoidRenderState)headRenderState).chestEquipment = animatable.getItemBySlot(EquipmentSlot.CHEST);
        equipment.put(EquipmentSlot.CHEST, ((HumanoidRenderState)headRenderState).chestEquipment);
        ((HumanoidRenderState)headRenderState).legsEquipment = animatable.getItemBySlot(EquipmentSlot.LEGS);
        equipment.put(EquipmentSlot.LEGS, ((HumanoidRenderState)headRenderState).legsEquipment);
        ((HumanoidRenderState)headRenderState).feetEquipment = animatable.getItemBySlot(EquipmentSlot.FEET);
        equipment.put(EquipmentSlot.FEET, ((HumanoidRenderState)headRenderState).feetEquipment);
        GeoArmorRenderer.captureRenderStates(headRenderState, animatable, partialTick, (renderState, slot) -> (HumanoidModel)GeckoLibClient.HUMANOID_ARMOR_MODEL.get().get(slot), slot -> slot == EquipmentSlot.HEAD ? headRenderState : this.getOrCreateHumanoidRenderState(baseRenderState, true));
        ((GeoRenderState)baseRenderState).addGeckolibData(DataTickets.EQUIPMENT_BY_SLOT, equipment);
        if (headRenderState != baseRenderState && ((GeoRenderState)headRenderState).hasGeckolibData(DataTickets.PER_SLOT_RENDER_DATA)) {
            ((GeoRenderState)baseRenderState).addGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, ((GeoRenderState)headRenderState).getGeckolibData(DataTickets.PER_SLOT_RENDER_DATA));
        }
    }

    @Override
    public void addPerBoneRender(RenderPassInfo<R> renderPassInfo, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        for (RenderData renderData : this.getRelevantBones(renderPassInfo)) {
            renderPassInfo.model().getBone(renderData.boneName).filter(CuboidGeoBone.class::isInstance).ifPresentOrElse(bone -> this.createPerBoneRender(renderPassInfo, (GeoBone)bone, renderData, consumer), () -> GeckoLibConstants.LOGGER.error("Unable to find bone for ItemArmorGeoLayer: {}, skipping", (Object)renderData.boneName));
        }
    }

    private void createPerBoneRender(RenderPassInfo<R> renderPassInfo, GeoBone bone, RenderData renderData, BiConsumer<GeoBone, PerBoneRender<R>> consumer) {
        GeoArmorRenderer.ArmorSegment armorSegment = renderData.armorSegment;
        ItemStack stack = this.getEquipmentStack(renderPassInfo, bone, armorSegment.equipmentSlot);
        if (!stack.isEmpty()) {
            consumer.accept(bone, (renderPassInfo2, bone2, renderTasks) -> this.buildRenderTask(renderPassInfo2, armorSegment.equipmentSlot, armorSegment.modelPartGetter, stack, (CuboidGeoBone)bone2, renderTasks));
        }
    }

    protected void buildRenderTask(RenderPassInfo<R> renderPassInfo, EquipmentSlot slot, Function<HumanoidModel<?>, ModelPart> modelPartFactory, ItemStack equipmentStack, CuboidGeoBone bone, SubmitNodeCollector renderTasks) {
        BlockItem blockItem;
        if (equipmentStack.isEmpty()) {
            return;
        }
        PoseStack poseStack = renderPassInfo.poseStack();
        EntityRenderState renderState = (EntityRenderState)renderPassInfo.renderState();
        Object object = equipmentStack.getItem();
        if (object instanceof BlockItem && (object = (blockItem = (BlockItem)object).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)object;
            this.renderSkullAsArmor(renderPassInfo, bone, equipmentStack, skullBlock, renderTasks);
        } else {
            object = RenderUtil.getGeckoLibArmorRenderer(equipmentStack, slot);
            if (object instanceof GeoArmorRenderer) {
                EntityRenderState slotRenderState;
                Object geoArmorRenderer = object;
                EnumMap perSlotData = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.PER_SLOT_RENDER_DATA, null);
                if (perSlotData != null && (slotRenderState = (EntityRenderState)perSlotData.get(slot)) != null) {
                    poseStack.pushPose();
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    GeoRenderState humanoidRenderState = (GeoRenderState)this.getOrCreateHumanoidRenderState(slotRenderState, false);
                    RenderPassInfo.BoneUpdater<R> boneUpdater = this.positionModelPartFromBone(poseStack, bone, modelPartFactory.apply(((GeoRenderState)slotRenderState).getGeckolibData(DataTickets.HUMANOID_MODEL)));
                    renderPassInfo.addBoneUpdater(boneUpdater);
                    geoArmorRenderer.performRenderPass(humanoidRenderState, poseStack, renderTasks, renderPassInfo.cameraState());
                    poseStack.popPose();
                }
            } else {
                ModelPart modelPart;
                Model<?> vanillaModel = this.getArmorModelForRender(bone, slot, equipmentStack, renderState);
                if (vanillaModel instanceof HumanoidModel) {
                    HumanoidModel humanoidModel = (HumanoidModel)vanillaModel;
                    v0 = modelPartFactory.apply(humanoidModel);
                } else {
                    v0 = modelPart = vanillaModel.root();
                }
                if (!modelPart.cubes.isEmpty()) {
                    poseStack.pushPose();
                    poseStack.scale(-1.0f, -1.0f, 1.0f);
                    Equippable equippable = (Equippable)equipmentStack.get(DataComponents.EQUIPPABLE);
                    if (equippable != null) {
                        equippable.assetId().ifPresent(assetId -> {
                            this.positionModelPartFromBone(poseStack, bone, modelPart);
                            this.renderVanillaArmorPiece(renderPassInfo, poseStack, bone, slot, equipmentStack, equippable, (ResourceKey<EquipmentAsset>)assetId, vanillaModel, modelPart, renderTasks);
                        });
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    protected ItemStack getEquipmentStack(RenderPassInfo<R> renderPassInfo, GeoBone bone, EquipmentSlot slot) {
        return renderPassInfo.getGeckolibData(DataTickets.EQUIPMENT_BY_SLOT).getOrDefault(slot, ItemStack.EMPTY);
    }

    protected EquipmentClientInfo.LayerType getEquipmentLayerType(RenderPassInfo<R> renderPassInfo, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, ResourceKey<EquipmentAsset> assetId) {
        if (slot == EquipmentSlot.LEGS) {
            return EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS;
        }
        if (slot == EquipmentSlot.CHEST && !this.equipmentAssets.get(assetId).getLayers(EquipmentClientInfo.LayerType.WINGS).isEmpty()) {
            return EquipmentClientInfo.LayerType.WINGS;
        }
        return EquipmentClientInfo.LayerType.HUMANOID;
    }

    protected void renderVanillaArmorPiece(RenderPassInfo<R> renderPassInfo, PoseStack poseStack, GeoBone bone, EquipmentSlot slot, ItemStack armorStack, Equippable equippable, ResourceKey<EquipmentAsset> assetId, Model<?> model, ModelPart modelPart, SubmitNodeCollector renderTasks) {
        EquipmentClientInfo.LayerType layerType = this.getEquipmentLayerType(renderPassInfo, bone, slot, armorStack, assetId);
        Model modelToRender = model;
        if (layerType == EquipmentClientInfo.LayerType.WINGS) {
            if (model instanceof HumanoidModel) {
                HumanoidModel humanoidModel = (HumanoidModel)model;
                if (modelPart != humanoidModel.body) {
                    return;
                }
            }
            modelToRender = this.checkForElytraModel(renderPassInfo, layerType, bone, poseStack);
        }
        this.equipmentRenderer.renderLayers(layerType, assetId, modelToRender, (Object)((EntityRenderState)renderPassInfo.renderState()), armorStack, poseStack, renderTasks, renderPassInfo.packedLight(), ((EntityRenderState)renderPassInfo.renderState()).outlineColor);
    }

    protected Model checkForElytraModel(RenderPassInfo<R> renderPassInfo, EquipmentClientInfo.LayerType layerType, GeoBone bone, PoseStack poseStack) {
        ElytraModel model = GeckoLibClient.GENERIC_ELYTRA_MODEL.get();
        HumanoidRenderState humanoidRenderState = new HumanoidRenderState();
        EntityRenderState renderState = (EntityRenderState)renderPassInfo.renderState();
        Vec3 elytraRotation = ((GeoRenderState)renderState).getOrDefaultGeckolibData(DataTickets.ELYTRA_ROTATION, Vec3.ZERO);
        humanoidRenderState.isCrouching = ((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_CROUCHING);
        humanoidRenderState.elytraRotX = (float)elytraRotation.x;
        humanoidRenderState.elytraRotY = (float)elytraRotation.y;
        humanoidRenderState.elytraRotZ = (float)elytraRotation.z;
        model.setupAnim(humanoidRenderState);
        poseStack.translate(0.0f, -1.5f, 0.125f);
        return model;
    }

    @NotNull
    @ApiStatus.Internal
    protected <S extends HumanoidRenderState> Model<?> getArmorModelForRender(GeoBone bone, EquipmentSlot slot, ItemStack stack, R renderState) {
        HumanoidRenderState humanoidRenderState1;
        HumanoidRenderState humanoidRenderState = renderState instanceof HumanoidRenderState ? (humanoidRenderState1 = (HumanoidRenderState)renderState) : new HumanoidRenderState();
        EquipmentClientInfo.LayerType layerType = slot == EquipmentSlot.LEGS ? EquipmentClientInfo.LayerType.HUMANOID_LEGGINGS : EquipmentClientInfo.LayerType.HUMANOID;
        HumanoidModel defaultModel = (HumanoidModel)GeckoLibClient.HUMANOID_ARMOR_MODEL.get().get(slot);
        return GeckoLibServices.Client.ITEM_RENDERING.getArmorModelForItem(humanoidRenderState, stack, slot, layerType, defaultModel);
    }

    protected void renderSkullAsArmor(RenderPassInfo<R> renderPassInfo, GeoBone bone, ItemStack stack, AbstractSkullBlock skullBlock, SubmitNodeCollector renderTasks) {
        SkullBlock.Type type = skullBlock.getType();
        SkullModelBase model = this.skullModels.apply(type);
        ResolvableProfile profile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        RenderType renderType = profile == null ? PlayerSkinRenderCache.DEFAULT_PLAYER_SKIN_RENDER_TYPE : this.skinCache.getOrDefault(profile).renderType();
        PoseStack poseStack = renderPassInfo.poseStack();
        poseStack.pushPose();
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        poseStack.scale(1.1875f, 1.1875f, 1.1875f);
        poseStack.translate(-0.5f, 0.0f, -0.5f);
        SkullBlockRenderer.submitSkull(null, (float)0.0f, (float)0.0f, (PoseStack)poseStack, (SubmitNodeCollector)renderTasks, (int)renderPassInfo.packedLight(), (SkullModelBase)model, (RenderType)renderType, (int)((EntityRenderState)renderPassInfo.renderState()).outlineColor, null);
        poseStack.popPose();
    }

    protected RenderPassInfo.BoneUpdater<R> positionModelPartFromBone(PoseStack poseStack, CuboidGeoBone bone, ModelPart sourcePart) {
        GeoCube firstCube = bone.cubes[0];
        ModelPart.Cube armorCube = (ModelPart.Cube)sourcePart.cubes.getFirst();
        double armorBoneSizeX = firstCube.size().x();
        double armorBoneSizeY = firstCube.size().y();
        double armorBoneSizeZ = firstCube.size().z();
        double actualArmorSizeX = Math.abs(armorCube.maxX - armorCube.minX);
        double actualArmorSizeY = Math.abs(armorCube.maxY - armorCube.minY);
        double actualArmorSizeZ = Math.abs(armorCube.maxZ - armorCube.minZ);
        float scaleX = (float)(armorBoneSizeX / actualArmorSizeX);
        float scaleY = (float)(armorBoneSizeY / actualArmorSizeY);
        float scaleZ = (float)(armorBoneSizeZ / actualArmorSizeZ);
        RenderPassInfo.BoneUpdater modelPositioner = (renderPassInfo, snapshots) -> {
            BoneSnapshot snapshot = snapshots.get(bone);
            sourcePart.setPos(-(bone.pivotX() - (bone.pivotX() * scaleX - bone.pivotX()) / scaleX), -(bone.pivotY() - (bone.pivotY() * scaleY - bone.pivotY()) / scaleY), bone.pivotZ() - (bone.pivotZ() * scaleZ - bone.pivotZ()) / scaleZ);
            sourcePart.xRot = -snapshot.getRotX();
            sourcePart.yRot = -snapshot.getRotY();
            sourcePart.zRot = snapshot.getRotZ();
        };
        poseStack.scale(scaleX, scaleY, scaleZ);
        return modelPositioner;
    }

    protected <S extends HumanoidRenderState> S getOrCreateHumanoidRenderState(R renderState, boolean forceNew) {
        HumanoidRenderState state;
        HumanoidRenderState newState;
        HumanoidRenderState humanoidRenderState = newState = !forceNew && renderState instanceof HumanoidRenderState ? (state = (HumanoidRenderState)renderState) : new HumanoidRenderState();
        if (newState != renderState) {
            RenderStateUtil.makeMinimalArmorRenderingClone(newState, renderState);
        }
        return (S)newState;
    }

    public record RenderData(String boneName, GeoArmorRenderer.ArmorSegment armorSegment) {
        public static RenderData head(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.HEAD);
        }

        public static RenderData body(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.CHEST);
        }

        public static RenderData leftArm(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_ARM);
        }

        public static RenderData rightArm(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_ARM);
        }

        public static RenderData leftLeg(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_LEG);
        }

        public static RenderData rightLeg(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_LEG);
        }

        public static RenderData leftFoot(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.LEFT_FOOT);
        }

        public static RenderData rightFoot(String boneName) {
            return new RenderData(boneName, GeoArmorRenderer.ArmorSegment.RIGHT_FOOT);
        }
    }
}

