/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import java.util.function.Function;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.Identifier;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class TextureLayerGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final Identifier texture;
    protected final Function<Identifier, RenderType> renderType;

    TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer) {
        this(renderer, MissingTextureAtlasSprite.getLocation(), null);
    }

    public TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer, Identifier texture) {
        this(renderer, texture, null);
    }

    public TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer, Identifier texture, Function<Identifier, RenderType> renderType) {
        super(renderer);
        this.texture = texture;
        this.renderType = renderType;
    }

    @Override
    protected Identifier getTextureResource(R renderState) {
        return this.texture;
    }

    protected RenderType getRenderType(R renderState) {
        Identifier texture = this.getTextureResource(renderState);
        if (this.renderType == null) {
            return this.renderer.getRenderType(renderState, texture);
        }
        return this.renderType.apply(texture);
    }

    @Override
    public void submitRenderTask(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        if (!renderPassInfo.willRender()) {
            return;
        }
        RenderType renderType = this.getRenderType(renderPassInfo.renderState());
        if (renderType != null) {
            this.renderer.submitRenderTasks(renderPassInfo, renderTasks.order(1), renderType);
        }
    }
}

