/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.specialty;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import org.joml.Quaternionfc;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;

public class DirectionalProjectileRenderer<T extends Projectile, R extends EntityRenderState>
extends GeoEntityRenderer<T, R> {
    public DirectionalProjectileRenderer(EntityRendererProvider.Context context, EntityType<? extends T> entityType) {
        this(context, new DefaultedEntityGeoModel(BuiltInRegistries.ENTITY_TYPE.getKey(entityType)));
    }

    public DirectionalProjectileRenderer(EntityRendererProvider.Context context, GeoModel<T> model) {
        super(context, model);
    }

    @Override
    protected void applyRotations(RenderPassInfo<R> renderPassInfo, PoseStack poseStack, float nativeScale) {
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderPassInfo.getGeckolibData(DataTickets.ENTITY_YAW).floatValue()));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(renderPassInfo.getGeckolibData(DataTickets.ENTITY_PITCH).floatValue()));
    }

    @Override
    protected float calculateYRot(T animatable, float yHeadRot, float partialTick) {
        return Mth.lerp((float)partialTick, (float)((Projectile)animatable).yRotO, (float)animatable.getYRot()) + 180.0f;
    }
}

