/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.specialty;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.util.ARGB;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.cache.model.BakedGeoModel;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.internal.BoneSnapshots;
import software.bernie.geckolib.renderer.internal.RenderPassInfo;

public abstract class DyeableGeoArmorRenderer<T extends Item, R extends HumanoidRenderState>
extends GeoArmorRenderer<T, R> {
    protected final Set<GeoBone> dyeableBones = new ReferenceOpenHashSet();
    protected BakedGeoModel lastModel = null;

    public DyeableGeoArmorRenderer(GeoModel<T> model) {
        super(model);
    }

    protected abstract boolean isBoneDyeable(GeoBone var1);

    protected int getColorForBone(R renderState, GeoBone bone, int baseColour) {
        return baseColour;
    }

    @Override
    public int getRenderColor(T animatable, GeoArmorRenderer.RenderData stackAndSlot, float partialTick) {
        return -1;
    }

    @Override
    public void preRenderPass(RenderPassInfo<R> renderPassInfo, SubmitNodeCollector renderTasks) {
        super.preRenderPass(renderPassInfo, renderTasks);
        this.checkBoneDyeCache(renderPassInfo);
        for (GeoBone bone : this.dyeableBones) {
            renderPassInfo.addPerBoneRender(bone, (renderPassInfo1, bone1, renderTasks1) -> {
                HumanoidRenderState renderState = (HumanoidRenderState)renderPassInfo1.renderState();
                int renderColor = renderPassInfo1.renderColor();
                renderTasks1.submitCustomGeometry(renderPassInfo1.poseStack(), this.getRenderType(renderState, this.getTextureLocation(renderState)), (pose, vertexConsumer) -> this.renderDyedBone(renderState, pose, bone1, renderPassInfo1, vertexConsumer, renderColor));
            });
        }
    }

    protected void renderDyedBone(R renderState, PoseStack.Pose pose, GeoBone bone1, RenderPassInfo<R> renderPassInfo1, VertexConsumer vertexConsumer, int renderColor) {
        PoseStack poseStack = new PoseStack();
        poseStack.last().set(pose);
        bone1.render(renderPassInfo1, new PoseStack(), vertexConsumer, renderPassInfo1.packedLight(), renderPassInfo1.packedOverlay(), ARGB.multiply((int)renderColor, (int)this.getColorForBone(renderState, bone1, ((GeoRenderState)renderState).getGeckolibData(DataTickets.RENDER_COLOR))));
    }

    @Override
    public void adjustModelBonesForRender(RenderPassInfo<R> renderPassInfo, BoneSnapshots snapshots) {
        for (GeoBone bone : this.dyeableBones) {
            snapshots.get(bone).skipRender(true);
        }
    }

    protected void checkBoneDyeCache(RenderPassInfo<R> renderPassInfo) {
        BakedGeoModel model = renderPassInfo.model();
        if (model != this.lastModel) {
            this.lastModel = model;
            this.dyeableBones.clear();
            this.collectDyeableBones(model.topLevelBones());
        }
    }

    protected void collectDyeableBones(GeoBone[] bones) {
        for (GeoBone bone : bones) {
            if (this.isBoneDyeable(bone)) {
                this.dyeableBones.add(bone);
            }
            this.collectDyeableBones(bone.children());
        }
    }
}

