/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureContents;
import net.minecraft.client.renderer.texture.TickableTexture;
import net.minecraft.client.resources.metadata.animation.AnimationFrame;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;

public class GeckoLibAnimatedTexture
extends SimpleTexture
implements TickableTexture {
    protected AnimationInfo animatedTexture;
    protected int frameWidth;
    protected int frameHeight;
    protected NativeImage baseImage;

    public GeckoLibAnimatedTexture(Identifier location) {
        super(location);
    }

    public boolean isAnimated() {
        return this.animatedTexture != null;
    }

    public TextureContents loadContents(ResourceManager resourceManager) throws IOException {
        Resource resource = resourceManager.getResourceOrThrow(this.resourceId());
        try (InputStream stream = resource.open();){
            this.baseImage = NativeImage.read((InputStream)stream);
        }
        if (this.baseImage != null) {
            this.animatedTexture = resource.metadata().getSection(AnimationMetadataSection.TYPE).map(this::buildAnimatedTexture).orElse(null);
        }
        return new TextureContents(this.baseImage, (TextureMetadataSection)resource.metadata().getSection(TextureMetadataSection.TYPE).orElse(null));
    }

    public void apply(TextureContents textureContents) {
        AddressMode address = textureContents.clamp() ? AddressMode.CLAMP_TO_EDGE : AddressMode.REPEAT;
        FilterMode filter = textureContents.blur() ? FilterMode.LINEAR : FilterMode.NEAREST;
        this.sampler = RenderSystem.getSamplerCache().getSampler(address, address, filter, filter, false);
        this.doLoad(this.baseImage);
    }

    public void doLoad(NativeImage image) {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        Identifier textureId = this.resourceId();
        Objects.requireNonNull(textureId);
        this.texture = gpuDevice.createTexture(() -> ((Identifier)textureId).toString(), 5, TextureFormat.RGBA8, this.frameWidth, this.frameHeight, 1, 1);
        this.textureView = gpuDevice.createTextureView(this.texture);
        this.uploadFrame(gpuDevice, image, 0, 0, this.texture);
    }

    @Nullable
    protected AnimationInfo buildAnimatedTexture(AnimationMetadataSection animMeta) {
        FrameSize frameSize = animMeta.calculateFrameSize(this.baseImage.getWidth(), this.baseImage.getHeight());
        this.frameWidth = frameSize.width();
        this.frameHeight = frameSize.height();
        int frameColumns = this.baseImage.getWidth() / this.frameWidth;
        int frameRows = this.baseImage.getHeight() / this.frameHeight;
        int frames = frameColumns * frameRows;
        int defaultFrameTime = animMeta.defaultFrameTime();
        int frameCount = animMeta.frames().map(List::size).orElse(frames);
        if (frameCount <= 1) {
            return null;
        }
        ObjectArrayList frameList = new ObjectArrayList(frameCount);
        if (animMeta.frames().isEmpty()) {
            for (int i = 0; i < frames; ++i) {
                frameList.add(new FrameInfo(i, defaultFrameTime));
            }
        } else {
            for (AnimationFrame frame : (List)animMeta.frames().get()) {
                frameList.add(new FrameInfo(frame.index(), frame.timeOr(defaultFrameTime)));
            }
            int frameIndex = 0;
            IntOpenHashSet validFrames = new IntOpenHashSet();
            Iterator iterator = frameList.iterator();
            while (iterator.hasNext()) {
                FrameInfo frameInfo = (FrameInfo)iterator.next();
                boolean validFrame = true;
                if (frameInfo.time <= 0) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)this.resourceId(), (Object)frameIndex, (Object)frameInfo.time);
                    validFrame = false;
                }
                if (frameInfo.index < 0 || frameInfo.index >= frames) {
                    GeckoLibConstants.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)this.resourceId(), (Object)frameIndex, (Object)frameInfo.index);
                    validFrame = false;
                }
                if (validFrame) {
                    validFrames.add(frameInfo.index);
                } else {
                    iterator.remove();
                }
                ++frameIndex;
            }
            int[] unusedFrames = IntStream.range(0, frames).filter(arg_0 -> GeckoLibAnimatedTexture.lambda$buildAnimatedTexture$0((IntSet)validFrames, arg_0)).toArray();
            if (unusedFrames.length > 0) {
                GeckoLibConstants.LOGGER.warn("Unused frames in sprite {}: {}", (Object)this.resourceId(), (Object)Arrays.toString(unusedFrames));
            }
        }
        return new AnimationInfo(List.copyOf(frameList), frameColumns, animMeta.interpolatedFrames());
    }

    protected void uploadFrame(GpuDevice gpuDevice, NativeImage image, int x, int y, GpuTexture gpuTexture) {
        gpuDevice.createCommandEncoder().writeToTexture(gpuTexture, image, 0, 0, x, y, this.frameWidth, this.frameHeight, 0, 0);
    }

    public void tick() {
        this.animatedTexture.tick();
    }

    public void close() {
        if (this.baseImage != null) {
            this.baseImage.close();
        }
        if (this.animatedTexture != null) {
            this.animatedTexture.close();
        }
        super.close();
    }

    private static /* synthetic */ boolean lambda$buildAnimatedTexture$0(IntSet validFrames, int frame) {
        return !validFrames.contains(frame);
    }

    protected class AnimationInfo
    implements AutoCloseable {
        protected final List<FrameInfo> frames;
        protected final int frameRowSize;
        protected final boolean interpolateFrames;
        @Nullable
        protected final InterpolationData interpolationData;
        protected final NativeImage currentFrameBuffer;
        int currentFrame;
        int subFrame;

        public AnimationInfo(List<FrameInfo> frames, int frameRowSize, boolean interpolateFrames) {
            this.frames = frames;
            this.frameRowSize = frameRowSize;
            this.interpolateFrames = interpolateFrames;
            this.interpolationData = this.interpolateFrames ? new InterpolationData(GeckoLibAnimatedTexture.this.frameWidth, GeckoLibAnimatedTexture.this.frameHeight) : null;
            this.currentFrameBuffer = new NativeImage(GeckoLibAnimatedTexture.this.frameWidth, GeckoLibAnimatedTexture.this.frameHeight, false);
        }

        int getFrameColumn(int frameIndex) {
            return frameIndex % this.frameRowSize;
        }

        int getFrameRow(int frameIndex) {
            return frameIndex / this.frameRowSize;
        }

        public void tick() {
            ++this.subFrame;
            FrameInfo prevFrameInfo = this.frames.get(this.currentFrame);
            if (this.subFrame >= prevFrameInfo.time) {
                this.currentFrame = (this.currentFrame + 1) % this.frames.size();
                this.subFrame = 0;
                int frameIndex = this.frames.get((int)this.currentFrame).index;
                if (prevFrameInfo.index != frameIndex) {
                    GeckoLibAnimatedTexture instance = GeckoLibAnimatedTexture.this;
                    int frameX = this.getFrameColumn(frameIndex) * instance.frameWidth;
                    int frameY = this.getFrameRow(frameIndex) * instance.frameHeight;
                    instance.baseImage.copyRect(this.currentFrameBuffer, frameX, frameY, 0, 0, instance.frameWidth, instance.frameHeight, false, false);
                    GeckoLibAnimatedTexture.this.uploadFrame(RenderSystem.getDevice(), this.currentFrameBuffer, 0, 0, GeckoLibAnimatedTexture.this.getTexture());
                }
            } else if (this.interpolationData != null) {
                this.interpolationData.tickAndUpload(GeckoLibAnimatedTexture.this.getTexture());
            }
        }

        @Override
        public void close() {
            if (this.interpolationData != null) {
                this.interpolationData.close();
            }
        }

        protected class InterpolationData
        implements AutoCloseable {
            protected final NativeImage buffer;

            public InterpolationData(int frameWidth, int frameHeight) {
                this.buffer = new NativeImage(frameWidth, frameHeight, false);
            }

            protected void tickAndUpload(GpuTexture gpuTexture) {
                AnimationInfo instance = AnimationInfo.this;
                List<FrameInfo> frames = instance.frames;
                FrameInfo currentFrameInfo = frames.get(instance.currentFrame);
                int nextFrameIndex = frames.get((int)((instance.currentFrame + 1) % frames.size())).index;
                if (currentFrameInfo.index != nextFrameIndex) {
                    float partialFrame = (float)instance.subFrame / (float)currentFrameInfo.time;
                    for (int pixelY = 0; pixelY < GeckoLibAnimatedTexture.this.frameHeight; ++pixelY) {
                        for (int pixelX = 0; pixelX < GeckoLibAnimatedTexture.this.frameWidth; ++pixelX) {
                            int framePixel = this.getPixel(instance, currentFrameInfo.index, pixelX, pixelY);
                            int nextFramePixel = this.getPixel(instance, nextFrameIndex, pixelX, pixelY);
                            this.buffer.setPixel(pixelX, pixelY, ARGB.linearLerp((float)partialFrame, (int)framePixel, (int)nextFramePixel));
                        }
                    }
                    GeckoLibAnimatedTexture.this.uploadFrame(RenderSystem.getDevice(), this.buffer, 0, 0, gpuTexture);
                }
            }

            protected int getPixel(AnimationInfo animationInfo, int frameIndex, int x, int y) {
                GeckoLibAnimatedTexture texture = GeckoLibAnimatedTexture.this;
                return texture.baseImage.getPixel(x + animationInfo.getFrameColumn(frameIndex) * texture.frameWidth, y + animationInfo.getFrameRow(frameIndex) * texture.frameHeight);
            }

            @Override
            public void close() {
                this.buffer.close();
            }
        }
    }

    protected record FrameInfo(int index, int time) {
    }
}

