/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.Blaze3D;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.MoonPhase;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public final class ClientUtil {
    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static boolean clientPlayerHasCape() {
        return Minecraft.getInstance().player.getSkin().cape() != null;
    }

    public static Vec3 getCameraPos() {
        return Minecraft.getInstance().gameRenderer.getMainCamera().position();
    }

    public static boolean isFirstPerson() {
        return Minecraft.getInstance().options.getCameraType().isFirstPerson();
    }

    public static MoonPhase getClientMoonPhase() {
        return Minecraft.getInstance().levelRenderer.levelRenderState.skyRenderState.moonPhase;
    }

    public static double getCurrentTick() {
        Minecraft mc = Minecraft.getInstance();
        return mc.level != null ? (double)((float)mc.level.getGameTime() + mc.getDeltaTracker().getGameTimeDeltaPartialTick(false)) : Blaze3D.getTime() * 20.0;
    }

    @ApiStatus.Internal
    public static int getVisibleEntityCount() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return 0;
        }
        return mc.levelRenderer.levelRenderState.entityRenderStates.size();
    }

    private ClientUtil() {
    }
}

