/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public final class JsonUtil {
    public static double[] jsonArrayToDoubleArray(@Nullable JsonArray array) throws JsonParseException {
        if (array == null) {
            return new double[3];
        }
        double[] output = new double[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            output[i] = array.get(i).getAsDouble();
        }
        return output;
    }

    public static <T> T[] jsonArrayToObjectArray(JsonArray array, JsonDeserializationContext context, Class<T> objectClass) {
        Object[] objArray = (Object[])Array.newInstance(objectClass, array.size());
        for (int i = 0; i < array.size(); ++i) {
            objArray[i] = context.deserialize(array.get(i), objectClass);
        }
        return objArray;
    }

    public static <T> List<T> jsonArrayToList(@Nullable JsonArray array, Function<JsonElement, T> elementTransformer) {
        if (array == null) {
            return new ObjectArrayList();
        }
        ObjectArrayList list = new ObjectArrayList(array.size());
        for (JsonElement element : array) {
            list.add(elementTransformer.apply(element));
        }
        return list;
    }

    public static <T> Map<String, T> jsonObjToMap(JsonObject obj, JsonDeserializationContext context, Class<T> objectType) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap(obj.size());
        for (Map.Entry entry : obj.entrySet()) {
            map.put((String)entry.getKey(), context.deserialize((JsonElement)entry.getValue(), objectType));
        }
        return map;
    }

    public static @Nullable Long getOptionalLong(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Long.valueOf(GsonHelper.getAsLong((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Boolean getOptionalBoolean(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Float getOptionalFloat(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Float.valueOf(GsonHelper.getAsFloat((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Double getOptionalDouble(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Double.valueOf(GsonHelper.getAsDouble((JsonObject)obj, (String)elementName)) : null;
    }

    public static @Nullable Integer getOptionalInteger(JsonObject obj, String elementName) {
        return obj.has(elementName) ? Integer.valueOf(GsonHelper.getAsInt((JsonObject)obj, (String)elementName)) : null;
    }

    public static Vec3 arrayToVec(double[] array) {
        return new Vec3(array[0], array[1], array[2]);
    }

    private JsonUtil() {
    }
}

