/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.util;

import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.cache.model.GeoBone;
import software.bernie.geckolib.cache.model.cuboid.GeoCube;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.renderer.GeoBlockRenderer;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;

public final class RenderUtil {
    public static void transformToBone(PoseStack poseStack, GeoBone bone) {
        ObjectArrayList boneQueue = new ObjectArrayList();
        GeoBone parent = bone;
        boneQueue.add(bone);
        while (parent.parent() != null) {
            parent = parent.parent();
            boneQueue.add(parent);
        }
        for (GeoBone bone2 : boneQueue) {
            RenderUtil.prepMatrixForBone(poseStack, bone2);
        }
    }

    public static void translateAndRotateMatrixForBone(PoseStack poseStack, GeoBone bone) {
        bone.translateToPivotPoint(poseStack);
        if (bone.baseRotZ() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotation(bone.baseRotZ()));
        }
        if (bone.baseRotY() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation(bone.baseRotY()));
        }
        if (bone.baseRotX() != 0.0f) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotation(bone.baseRotX()));
        }
        if (bone.frameSnapshot != null) {
            bone.frameSnapshot.rotate(poseStack);
        }
    }

    public static void prepMatrixForBone(PoseStack poseStack, GeoBone bone) {
        if (bone.frameSnapshot != null) {
            bone.frameSnapshot.translate(poseStack);
        }
        RenderUtil.translateAndRotateMatrixForBone(poseStack, bone);
        bone.translateAwayFromPivotPoint(poseStack);
    }

    public static Vec3 renderPoseToPosition(Matrix4fc pose, float xScale, float yScale, float zScale) {
        Vector4f position = pose.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        return new Vec3((double)(position.x() * xScale), (double)(position.y() * yScale), (double)(position.z() * zScale));
    }

    public static Matrix4f extractPoseFromRoot(Matrix4fc baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul(baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(PoseStack poseStack, Entity animatable, float partialTick) {
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot()) - 90.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        return matrix.add((Matrix4fc)new Matrix4f().m30(vector.x).m31(vector.y).m32(vector.z));
    }

    public static IntIntPair getTextureDimensions(Identifier texture) {
        GpuTexture gpuTexture = Minecraft.getInstance().getTextureManager().getTexture(texture).getTexture();
        return IntIntPair.of((int)gpuTexture.getWidth(0), (int)gpuTexture.getHeight(0));
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().y() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().x() == 0.0 || cube.size().z() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().x() == 0.0 || cube.size().y() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static Identifier getEmissiveResource(Identifier textureLocation) {
        return textureLocation.withPath(path -> path.replace(".png", "_glowmask.png"));
    }

    public static @Nullable GeoReplacedEntityRenderer<?, ?, ?> getReplacedEntityRenderer(EntityType<?> entityType) {
        GeoReplacedEntityRenderer replacedEntityRenderer;
        Object v = Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(entityType);
        return v instanceof GeoReplacedEntityRenderer ? (replacedEntityRenderer = (GeoReplacedEntityRenderer)v) : null;
    }

    public static @Nullable GeoItemRenderer<?> getGeckoLibItemRenderer(Item item) {
        return GeoRenderProvider.of(item).getGeoItemRenderer();
    }

    public static @Nullable GeoEntityRenderer<?, ?> getGeckoLibEntityRenderer(EntityType<?> entityType) {
        GeoEntityRenderer geoEntityRenderer;
        Object v = Minecraft.getInstance().getEntityRenderDispatcher().renderers.get(entityType);
        return v instanceof GeoEntityRenderer ? (geoEntityRenderer = (GeoEntityRenderer)v) : null;
    }

    public static @Nullable GeoBlockRenderer<?, ?> getGeckoLibBlockRenderer(BlockEntityType<?> blockEntityType) {
        GeoBlockRenderer geoBlockRenderer;
        Object v = Minecraft.getInstance().getBlockEntityRenderDispatcher().renderers.get(blockEntityType);
        return v instanceof GeoBlockRenderer ? (geoBlockRenderer = (GeoBlockRenderer)v) : null;
    }

    public static @Nullable GeoArmorRenderer<?, ?> getGeckoLibArmorRenderer(Item item) {
        ItemStack stack = item.getDefaultInstance();
        Equippable equippable = (Equippable)stack.getOrDefault(DataComponents.EQUIPPABLE, null);
        if (equippable == null) {
            return null;
        }
        return RenderUtil.getGeckoLibArmorRenderer(stack, equippable.slot());
    }

    public static @Nullable GeoArmorRenderer<?, ?> getGeckoLibArmorRenderer(ItemStack stack, EquipmentSlot slot) {
        return GeoRenderProvider.of(stack).getGeoArmorRenderer(stack, slot);
    }

    public static @Nullable GeoAnimatable getReplacedAnimatable(EntityType<?> entityType) {
        GeoReplacedEntityRenderer<?, ?, ?> replacedEntityRenderer = RenderUtil.getReplacedEntityRenderer(entityType);
        return replacedEntityRenderer == null ? null : (GeoAnimatable)replacedEntityRenderer.getAnimatable();
    }

    private RenderUtil() {
    }
}

