/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animatable.stateless;

import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.stateless.StatelessAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.cache.SyncedSingletonAnimatableCache;
import software.bernie.geckolib.network.packet.singleton.StatelessSingletonPlayAnimPacket;
import software.bernie.geckolib.network.packet.singleton.StatelessSingletonStopAnimPacket;

public non-sealed interface StatelessGeoSingletonAnimatable
extends StatelessAnimatable,
SingletonGeoAnimatable {
    default public void playAnimation(String animation, Entity relatedEntity, long instanceId) {
        this.playAnimation(RawAnimation.begin().thenPlay(animation), relatedEntity, instanceId);
    }

    default public void playLoopingAnimation(String animation, Entity relatedEntity, long instanceId) {
        this.playAnimation(RawAnimation.begin().thenLoop(animation), relatedEntity, instanceId);
    }

    default public void playAndHoldAnimation(String animation, Entity relatedEntity, long instanceId) {
        this.playAnimation(RawAnimation.begin().thenPlayAndHold(animation), relatedEntity, instanceId);
    }

    default public void stopAnimation(RawAnimation animation, Entity relatedEntity, long instanceId) {
        this.stopAnimation(animation.getStageCount() == 1 ? animation.getAnimationStages().getFirst().animationName() : animation.toString(), relatedEntity, instanceId);
    }

    default public void playAnimation(RawAnimation animation, Entity relatedEntity, long instanceId) {
        if (relatedEntity.level().isClientSide()) {
            this.handleClientAnimationPlay(this, instanceId, animation);
        } else {
            GeckoLibServices.NETWORK.sendToAllPlayersTrackingEntity(new StatelessSingletonPlayAnimPacket(SyncedSingletonAnimatableCache.getOrCreateId(this), instanceId, animation), relatedEntity);
        }
    }

    default public void stopAnimation(String animation, Entity relatedEntity, long instanceId) {
        if (relatedEntity.level().isClientSide()) {
            this.handleClientAnimationStop(this, instanceId, animation);
        } else {
            GeckoLibServices.NETWORK.sendToAllPlayersTrackingEntity(new StatelessSingletonStopAnimPacket(SyncedSingletonAnimatableCache.getOrCreateId(this), instanceId, animation), relatedEntity);
        }
    }

    @Override
    @Deprecated
    default public void playAnimation(String animation) {
        throw new IllegalStateException("Cannot use non-level method handlers on StatelessSingletonGeoAnimatable");
    }

    @Override
    @Deprecated
    default public void playLoopingAnimation(String animation) {
        throw new IllegalStateException("Cannot use non-level method handlers on StatelessSingletonGeoAnimatable");
    }

    @Override
    @Deprecated
    default public void playAndHoldAnimation(String animation) {
        throw new IllegalStateException("Cannot use non-level method handlers on StatelessSingletonGeoAnimatable");
    }

    @Override
    @Deprecated
    default public void stopAnimation(RawAnimation animation) {
        throw new IllegalStateException("Cannot use non-level method handlers on StatelessSingletonGeoAnimatable");
    }

    @Override
    @Deprecated
    default public void playAnimation(RawAnimation animation) {
        throw new IllegalStateException("Cannot use non-level method handlers on StatelessSingletonGeoAnimatable");
    }

    @Override
    @Deprecated
    default public void stopAnimation(String animation) {
        throw new IllegalStateException("Cannot use non-level method handlers on StatelessSingletonGeoAnimatable");
    }
}

