/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.animation.keyframe.event.handler;

import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.processing.AnimationController;
import software.bernie.geckolib.animatable.processing.AnimationState;
import software.bernie.geckolib.animation.keyframe.event.KeyFrameEvent;
import software.bernie.geckolib.animation.keyframe.event.data.SoundKeyframeData;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.util.ClientUtil;

public class AutoPlayingSoundKeyframeHandler<A extends GeoAnimatable>
implements AnimationController.KeyframeEventHandler<A, SoundKeyframeData> {
    @Override
    public void handle(KeyFrameEvent<A, SoundKeyframeData> event) {
        String[] segments = event.keyframeData().getSound().split("\\|");
        BuiltInRegistries.SOUND_EVENT.get((ResourceLocation)ResourceLocation.read((String)segments[0]).getOrThrow()).ifPresent(sound -> {
            Vec3 vec3;
            AnimationState animationState = event.animationState();
            GeoRenderState patt0$temp = event.animationState().renderState();
            if (patt0$temp instanceof EntityRenderState) {
                EntityRenderState entityState = (EntityRenderState)patt0$temp;
                vec3 = new Vec3(entityState.x, entityState.y, entityState.z);
            } else {
                vec3 = null;
            }
            Vec3 position = animationState.getDataOrDefault(DataTickets.POSITION, vec3);
            Class<Object> animatableClass = event.animationState().getDataOrDefault(DataTickets.ANIMATABLE_CLASS, Object.class);
            if (position != null) {
                float pitch;
                float volume = segments.length > 1 ? Float.parseFloat(segments[1]) : 1.0f;
                float f = pitch = segments.length > 2 ? Float.parseFloat(segments[2]) : 1.0f;
                SoundSource source = animatableClass.isAssignableFrom(BlockEntity.class) ? SoundSource.BLOCKS : (animatableClass.isAssignableFrom(Enemy.class) ? SoundSource.HOSTILE : SoundSource.NEUTRAL);
                ClientUtil.getLevel().playLocalSound(position.x, position.y, position.z, (SoundEvent)sound.value(), source, volume, pitch, false);
            } else {
                GeckoLibConstants.LOGGER.warn("Found sound keyframe handler, but AnimationState had no position data for animatable: {}", (Object)animatableClass.getName());
            }
        });
    }
}

