/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet.blockentity;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.stateless.StatelessGeoBlockEntity;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.ClientUtil;

public record StatelessBlockEntityStopAnimPacket(BlockPos blockPos, String animation) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<StatelessBlockEntityStopAnimPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("stateless_block_entity_stop_anim"));
    public static final StreamCodec<FriendlyByteBuf, StatelessBlockEntityStopAnimPacket> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, StatelessBlockEntityStopAnimPacket::blockPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, StatelessBlockEntityStopAnimPacket::animation, StatelessBlockEntityStopAnimPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            GeoBlockEntity blockEntity;
            BlockEntity patt0$temp = ClientUtil.getLevel().getBlockEntity(this.blockPos);
            if (patt0$temp instanceof GeoBlockEntity && (blockEntity = (GeoBlockEntity)patt0$temp) instanceof StatelessGeoBlockEntity) {
                StatelessGeoBlockEntity statelessAnimatable = (StatelessGeoBlockEntity)blockEntity;
                statelessAnimatable.handleClientAnimationStop(blockEntity, 0L, this.animation);
            }
        });
    }
}

