/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.platform;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.service.GeckoLibClient;

public class GeckoLibClientNeoForge
implements GeckoLibClient {
    @Override
    @NotNull
    public <S extends HumanoidRenderState> Model<?> getArmorModelForItem(S entityRenderState, ItemStack stack, EquipmentSlot slot, EquipmentClientInfo.LayerType type, HumanoidModel<S> defaultModel) {
        return IClientItemExtensions.of((ItemStack)stack).getGenericArmorModel(stack, type, defaultModel);
    }

    @Override
    @Nullable
    public GeoModel<?> getGeoModelForItem(ItemStack item) {
        GeoItemRenderer<?> geoItemRenderer = GeoRenderProvider.of(item).getGeoItemRenderer();
        if (geoItemRenderer instanceof GeoRenderer) {
            GeoItemRenderer<?> geoRenderer = geoItemRenderer;
            return geoRenderer.getGeoModel();
        }
        return null;
    }

    @Override
    public int getDyedItemColor(ItemStack itemStack, int defaultColor) {
        int colour = IClientItemExtensions.of((ItemStack)itemStack).getDefaultDyeColor(itemStack);
        return colour == 0 ? defaultColor : colour;
    }
}

