/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedBlockGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtil;

public class GeoBlockRenderer<T extends BlockEntity, R extends BlockEntityRenderState>
implements GeoRenderer<T, Void, R>,
BlockEntityRenderer<T, R> {
    protected final GeoRenderLayersContainer<T, Void, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoBlockRenderer(BlockEntityType<? extends T> blockEntityType) {
        this(new DefaultedBlockGeoModel(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType)));
    }

    public GeoBlockRenderer(GeoModel<T> model) {
        this.model = model;
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoBlockRenderer<T, R> withRenderLayer(Function<? super GeoBlockRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoBlockRenderer<T, R> withRenderLayer(GeoRenderLayer<T, Void, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoBlockRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoBlockRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, Void relatedObject) {
        return animatable.getBlockPos().hashCode();
    }

    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCKSTATE, animatable.getBlockState());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.POSITION, Vec3.atCenterOf((Vec3i)animatable.getBlockPos()));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCK_FACING, this.getFacing(animatable));
        return renderState;
    }

    @Override
    public void preRender(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        poseStack.translate(0.5, 0.0, 0.5);
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, PoseStack poseStack, BakedGeoModel model, CameraRenderState cameraState) {
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth, heightScale * this.scaleHeight, poseStack, model, cameraState);
    }

    @Override
    public void adjustRenderPose(R renderState, PoseStack poseStack, BakedGeoModel model, CameraRenderState cameraState) {
        this.rotateBlock(((GeoRenderState)renderState).getGeckolibData(DataTickets.BLOCK_FACING), poseStack);
    }

    @ApiStatus.Internal
    public void submit(R renderState, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraRenderState) {
        this.submitRenderTasks(renderState, poseStack, renderTasks, cameraRenderState, null);
    }

    @Override
    public void renderBone(R renderState, PoseStack poseStack, GeoBone bone, VertexConsumer buffer, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.OBJECT_RENDER_POSE));
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            BlockPos pos = ((BlockEntityRenderState)renderState).blockPos;
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.MODEL_RENDER_POSE)));
            bone.setLocalSpaceMatrix(localMatrix);
            bone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.getX(), (float)pos.getY(), (float)pos.getZ())));
        }
        GeoRenderer.super.renderBone(renderState, poseStack, bone, buffer, cameraState, packedLight, packedOverlay, renderColor);
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose((Quaternionfc)Axis.YN.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
                break;
            }
        }
    }

    protected Direction getFacing(T blockEntity) {
        BlockState blockState = blockEntity.getBlockState();
        if (blockState.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
            return (Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING);
        }
        if (blockState.hasProperty((Property)DirectionalBlock.FACING)) {
            return (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        }
        return Direction.NORTH;
    }

    @ApiStatus.Internal
    public R createRenderState() {
        return (R)new BlockEntityRenderState();
    }

    public void extractRenderState(T blockEntity, R renderState, float partialTick, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay damageOverlayState) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, damageOverlayState);
        this.fillRenderState(blockEntity, null, renderState, partialTick);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileBlockRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState) {
        return GeckoLibServices.Client.EVENTS.fireBlockPreRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    public void firePostRenderEvent(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState) {
        GeckoLibServices.Client.EVENTS.fireBlockPostRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    @Deprecated
    @ApiStatus.Internal
    public final R createRenderState(T animatable, Void relatedObject) {
        return (R)new BlockEntityRenderState();
    }
}

