/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.GeckoLibServices;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public class GeoEntityRenderer<T extends Entity, R extends EntityRenderState>
extends EntityRenderer<T, R>
implements GeoRenderer<T, Void, R> {
    protected final GeoRenderLayersContainer<T, Void, R> renderLayers = new GeoRenderLayersContainer(this);
    protected final GeoModel<T> model;
    protected final ItemModelResolver itemModelResolver;
    protected float scaleWidth = 1.0f;
    protected float scaleHeight = 1.0f;

    public GeoEntityRenderer(EntityRendererProvider.Context context, EntityType<? extends T> entityType) {
        this(context, new DefaultedEntityGeoModel(BuiltInRegistries.ENTITY_TYPE.getKey(entityType)));
    }

    public GeoEntityRenderer(EntityRendererProvider.Context context, GeoModel<T> model) {
        super(context);
        this.model = model;
        this.itemModelResolver = context.getItemModelResolver();
    }

    @Override
    public GeoModel<T> getGeoModel() {
        return this.model;
    }

    @Override
    public List<GeoRenderLayer<T, Void, R>> getRenderLayers() {
        return this.renderLayers.getRenderLayers();
    }

    public GeoEntityRenderer<T, R> withRenderLayer(Function<? super GeoEntityRenderer<T, R>, GeoRenderLayer<T, Void, R>> renderLayer) {
        return this.withRenderLayer(renderLayer.apply(this));
    }

    public GeoEntityRenderer<T, R> withRenderLayer(GeoRenderLayer<T, Void, R> renderLayer) {
        this.renderLayers.addLayer(renderLayer);
        return this;
    }

    public GeoEntityRenderer<T, R> withScale(float scale) {
        return this.withScale(scale, scale);
    }

    public GeoEntityRenderer<T, R> withScale(float scaleWidth, float scaleHeight) {
        this.scaleWidth = scaleWidth;
        this.scaleHeight = scaleHeight;
        return this;
    }

    @Override
    @ApiStatus.Internal
    public long getInstanceId(T animatable, Void relatedObject) {
        return animatable.getId();
    }

    @Override
    public int getRenderColor(T animatable, Void relatedObject, float partialTick) {
        int color = GeoRenderer.super.getRenderColor(animatable, relatedObject, partialTick);
        if (animatable.isInvisible() && !animatable.isInvisibleTo(ClientUtil.getClientPlayer())) {
            color = ARGB.color((int)Mth.ceil((float)((float)(ARGB.alpha((int)color) * 38) / 255.0f)), (int)color);
        }
        return color;
    }

    @Override
    public int getPackedOverlay(T animatable, Void relatedObject, float u, float partialTick) {
        if (!(animatable instanceof LivingEntity)) {
            return OverlayTexture.NO_OVERLAY;
        }
        LivingEntity entity = (LivingEntity)animatable;
        return OverlayTexture.pack((int)OverlayTexture.u((float)u), (int)OverlayTexture.v((entity.hurtTime > 0 || entity.deathTime > 0 ? 1 : 0) != 0));
    }

    public double getNameRenderCutoffDistance(T animatable) {
        return 32.0;
    }

    protected float getDeathMaxRotation(GeoRenderState renderState) {
        return 90.0f;
    }

    public boolean shouldShowName(T animatable, double distToCameraSq) {
        double nameRenderCutoff;
        if (!(animatable instanceof LivingEntity)) {
            return super.shouldShowName(animatable, distToCameraSq);
        }
        if (animatable.isDiscrete() && distToCameraSq >= (nameRenderCutoff = this.getNameRenderCutoffDistance(animatable)) * nameRenderCutoff) {
            return false;
        }
        if (!(!(animatable instanceof Mob) || animatable.shouldShowName() || animatable.hasCustomName() && animatable == this.entityRenderDispatcher.crosshairPickEntity)) {
            return false;
        }
        Minecraft minecraft = Minecraft.getInstance();
        boolean visibleToClient = !animatable.isInvisibleTo(ClientUtil.getClientPlayer());
        PlayerTeam entityTeam = animatable.getTeam();
        if (entityTeam == null) {
            return Minecraft.renderNames() && animatable != minecraft.getCameraEntity() && visibleToClient && !animatable.isVehicle();
        }
        PlayerTeam playerTeam = ClientUtil.getClientPlayer().getTeam();
        return switch (entityTeam.getNameTagVisibility()) {
            default -> throw new MatchException(null, null);
            case Team.Visibility.ALWAYS -> visibleToClient;
            case Team.Visibility.NEVER -> false;
            case Team.Visibility.HIDE_FOR_OTHER_TEAMS -> {
                if (playerTeam == null) {
                    yield visibleToClient;
                }
                if (entityTeam.isAlliedTo((Team)playerTeam) && (entityTeam.canSeeFriendlyInvisibles() || visibleToClient)) {
                    yield true;
                }
                yield false;
            }
            case Team.Visibility.HIDE_FOR_OWN_TEAM -> playerTeam == null ? visibleToClient : !entityTeam.isAlliedTo((Team)playerTeam) && visibleToClient;
        };
    }

    protected float calculateYRot(T animatable, float yHeadRot, float partialTick) {
        Entity entity = animatable.getVehicle();
        if (!(entity instanceof LivingEntity)) {
            return animatable.getVisualRotationYInDegrees();
        }
        LivingEntity vehicle = (LivingEntity)entity;
        float vehicleRotation = Mth.rotLerp((float)partialTick, (float)vehicle.yBodyRotO, (float)vehicle.yBodyRot);
        float clampedVehicleRotation = Mth.clamp((float)Mth.wrapDegrees((float)(-vehicleRotation)), (float)-85.0f, (float)85.0f);
        vehicleRotation = yHeadRot - vehicleRotation;
        if (Math.abs(clampedVehicleRotation) > 50.0f) {
            vehicleRotation += clampedVehicleRotation * 0.2f;
        }
        return vehicleRotation;
    }

    @Override
    @Nullable
    public RenderType getRenderType(R renderState, ResourceLocation texture) {
        if (((EntityRenderState)renderState).isInvisible && !((GeoRenderState)renderState).getGeckolibData(DataTickets.INVISIBLE_TO_PLAYER).booleanValue()) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)texture);
        }
        if (!((EntityRenderState)renderState).isInvisible) {
            return GeoRenderer.super.getRenderType(renderState, texture);
        }
        return renderState.appearsGlowing() ? RenderType.outline((ResourceLocation)texture) : null;
    }

    @Override
    @ApiStatus.Internal
    public R captureDefaultRenderState(T animatable, Void relatedObject, R renderState, float partialTick) {
        double d;
        LivingEntity livingEntity;
        LivingEntityRenderState state;
        GeoRenderer.super.captureDefaultRenderState(animatable, relatedObject, renderState, partialTick);
        LivingEntityRenderState livingRenderState = renderState instanceof LivingEntityRenderState ? (state = (LivingEntityRenderState)renderState) : null;
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.INVISIBLE_TO_PLAYER, livingRenderState != null ? livingRenderState.isInvisibleToPlayer : animatable.isInvisible() && animatable.isInvisibleTo(ClientUtil.getClientPlayer()));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_SHAKING, livingRenderState != null ? livingRenderState.isFullyFrozen : animatable.isFullyFrozen());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_POSE, livingRenderState != null ? livingRenderState.pose : animatable.getPose());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_PITCH, Float.valueOf(livingRenderState != null ? livingRenderState.xRot : animatable.getXRot(partialTick)));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_YAW, Float.valueOf(livingRenderState != null ? livingRenderState.yRot : this.calculateYRot(animatable, 0.0f, partialTick)));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.ENTITY_BODY_YAW, livingRenderState != null ? Float.valueOf(livingRenderState.bodyRot) : ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_YAW));
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.VELOCITY, animatable.getDeltaMovement());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.BLOCKPOS, animatable.blockPosition());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.SPRINTING, animatable.isSprinting());
        ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_CROUCHING, animatable.isCrouching());
        GeoRenderState geoRenderState = (GeoRenderState)renderState;
        if (animatable instanceof LivingEntity) {
            livingEntity = (LivingEntity)animatable;
            d = livingEntity.walkAnimation.speed();
        } else {
            d = animatable.getDeltaMovement().lengthSqr();
        }
        geoRenderState.addGeckolibData(DataTickets.IS_MOVING, d >= (double)this.getMotionAnimThreshold((GeoAnimatable)animatable));
        if (animatable instanceof LivingEntity) {
            livingEntity = (LivingEntity)animatable;
            ((GeoRenderState)renderState).addGeckolibData(DataTickets.SWINGING_ARM, livingEntity.swinging);
            ((GeoRenderState)renderState).addGeckolibData(DataTickets.IS_DEAD_OR_DYING, livingEntity.isDeadOrDying());
        }
        return renderState;
    }

    @Override
    public void scaleModelForRender(R renderState, float widthScale, float heightScale, PoseStack poseStack, BakedGeoModel model, CameraRenderState cameraState) {
        float f;
        if (renderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingRenderState = (LivingEntityRenderState)renderState;
            f = livingRenderState.scale;
        } else {
            f = 1.0f;
        }
        float nativeScale = f;
        GeoRenderer.super.scaleModelForRender(renderState, widthScale * this.scaleWidth * nativeScale, heightScale * this.scaleHeight * nativeScale, poseStack, model, cameraState);
    }

    @Override
    public void adjustRenderPose(R renderState, PoseStack poseStack, BakedGeoModel model, CameraRenderState cameraState) {
        Direction bedDirection;
        LivingEntityRenderState state;
        LivingEntityRenderState livingRenderState;
        LivingEntityRenderState livingEntityRenderState = livingRenderState = renderState instanceof LivingEntityRenderState ? (state = (LivingEntityRenderState)renderState) : null;
        if (livingRenderState != null && ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_POSE) == Pose.SLEEPING && (bedDirection = livingRenderState.bedOrientation) != null) {
            float eyePosOffset = livingRenderState.eyeHeight - 0.1f;
            poseStack.translate((float)(-bedDirection.getStepX()) * eyePosOffset, 0.0f, (float)(-bedDirection.getStepZ()) * eyePosOffset);
        }
        this.applyRotations(renderState, poseStack, livingRenderState != null ? livingRenderState.scale : 1.0f, cameraState);
        poseStack.translate(0.0f, 0.01f, 0.0f);
    }

    @ApiStatus.Internal
    public void submit(R renderState, PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraState) {
        this.submitRenderTasks((GeoRenderState)renderState, poseStack, renderTasks, cameraState, null);
    }

    @Override
    public void renderFinal(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        super.submit(renderState, poseStack, renderTasks, cameraState);
    }

    @Override
    public void renderBone(R renderState, PoseStack poseStack, GeoBone bone, VertexConsumer buffer, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor) {
        poseStack.pushPose();
        RenderUtil.translateMatrixToBone(poseStack, bone);
        RenderUtil.translateToPivotPoint(poseStack, bone);
        RenderUtil.rotateMatrixAroundBone(poseStack, bone);
        RenderUtil.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.last().pose());
            Matrix4f localMatrix = RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.OBJECT_RENDER_POSE));
            bone.setModelSpaceMatrix(RenderUtil.invertAndMultiplyMatrices(poseState, ((GeoRenderState)renderState).getGeckolibData(DataTickets.MODEL_RENDER_POSE)));
            bone.setLocalSpaceMatrix(RenderUtil.translateMatrix(localMatrix, this.getRenderOffset((EntityRenderState)renderState).toVector3f()));
            bone.setWorldSpaceMatrix(RenderUtil.translateMatrix(new Matrix4f((Matrix4fc)localMatrix), new Vector3f((float)((EntityRenderState)renderState).x, (float)((EntityRenderState)renderState).y, (float)((EntityRenderState)renderState).z)));
        }
        RenderUtil.translateAwayFromPivotPoint(poseStack, bone);
        this.renderCubesOfBone((GeoRenderState)renderState, bone, poseStack, buffer, cameraState, packedLight, packedOverlay, renderColor);
        this.renderChildBones((GeoRenderState)renderState, bone, poseStack, buffer, cameraState, packedLight, packedOverlay, renderColor);
        poseStack.popPose();
    }

    protected void applyRotations(R renderState, PoseStack poseStack, float nativeScale, CameraRenderState cameraState) {
        boolean sleeping;
        float rotationYaw = ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_BODY_YAW).floatValue();
        if (((GeoRenderState)renderState).getGeckolibData(DataTickets.IS_SHAKING).booleanValue()) {
            rotationYaw += (float)(Math.cos((double)((EntityRenderState)renderState).ageInTicks * 3.25) * Math.PI * 0.4);
        }
        boolean bl = sleeping = ((GeoRenderState)renderState).getGeckolibData(DataTickets.ENTITY_POSE) == Pose.SLEEPING;
        if (!sleeping) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - rotationYaw));
        }
        if (renderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingRenderState = (LivingEntityRenderState)renderState;
            if (livingRenderState.deathTime > 0.0f) {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(Math.min(Mth.sqrt((float)((livingRenderState.deathTime - 1.0f) / 20.0f * 1.6f)), 1.0f) * this.getDeathMaxRotation((GeoRenderState)renderState)));
            } else if (livingRenderState.isAutoSpinAttack) {
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f - livingRenderState.xRot));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(((EntityRenderState)renderState).ageInTicks * -75.0f));
            } else if (sleeping) {
                Direction bedOrientation = livingRenderState.bedOrientation;
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(bedOrientation != null ? RenderUtil.getDirectionAngle(bedOrientation) : rotationYaw));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(this.getDeathMaxRotation((GeoRenderState)renderState)));
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            } else if (livingRenderState.isUpsideDown) {
                poseStack.translate(0.0f, (livingRenderState.boundingBoxHeight + 0.1f) / nativeScale, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
            }
        }
    }

    @Override
    public R createRenderState(T animatable, Void relatedObject) {
        return (R)(animatable instanceof LivingEntity ? new LivingEntityRenderState() : new EntityRenderState());
    }

    @Override
    @ApiStatus.Internal
    public final R createRenderState(T entity, float partialTick) {
        R renderState = this.createRenderState(entity, null);
        this.extractRenderState(entity, renderState, partialTick);
        this.finalizeRenderState((Entity)entity, (EntityRenderState)renderState);
        return renderState;
    }

    @ApiStatus.OverrideOnly
    public void extractRenderState(T entity, R entityRenderState, float partialTick) {
        super.extractRenderState(entity, entityRenderState, partialTick);
        if (entityRenderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)entityRenderState;
            this.extractLivingEntityRenderState((LivingEntity)entity, livingEntityRenderState, partialTick, this.itemModelResolver);
        }
        this.fillRenderState((GeoAnimatable)entity, null, (GeoRenderState)entityRenderState, partialTick);
    }

    protected void extractLivingEntityRenderState(LivingEntity entity, LivingEntityRenderState renderState, float partialTick, ItemModelResolver itemModelResolver) {
        BlockItem blockItem;
        Minecraft minecraft = Minecraft.getInstance();
        float lerpHeadYRot = Mth.rotLerp((float)partialTick, (float)entity.yHeadRotO, (float)entity.yHeadRot);
        Component customName = entity.getCustomName();
        ItemStack helmetStack = entity.getItemBySlot(EquipmentSlot.HEAD);
        renderState.bodyRot = LivingEntityRenderer.solveBodyRot((LivingEntity)entity, (float)lerpHeadYRot, (float)partialTick);
        renderState.yRot = Mth.wrapDegrees((float)(lerpHeadYRot - renderState.bodyRot));
        renderState.xRot = entity.getXRot(partialTick);
        boolean bl = renderState.isUpsideDown = customName != null && LivingEntityRenderer.isUpsideDownName((String)customName.getString());
        if (renderState.isUpsideDown) {
            renderState.xRot *= -1.0f;
            renderState.yRot *= -1.0f;
        }
        if (!entity.isPassenger() && entity.isAlive()) {
            renderState.walkAnimationPos = entity.walkAnimation.position(partialTick);
            renderState.walkAnimationSpeed = entity.walkAnimation.speed(partialTick);
        } else {
            renderState.walkAnimationPos = 0.0f;
            renderState.walkAnimationSpeed = 0.0f;
        }
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            renderState.wornHeadAnimationPos = vehicle.walkAnimation.position(partialTick);
        } else {
            renderState.wornHeadAnimationPos = renderState.walkAnimationPos;
        }
        renderState.scale = entity.getScale();
        renderState.ageScale = entity.getAgeScale();
        renderState.pose = entity.getPose();
        renderState.bedOrientation = entity.getBedOrientation();
        if (renderState.bedOrientation != null) {
            renderState.eyeHeight = entity.getEyeHeight(Pose.STANDING);
        }
        renderState.isFullyFrozen = entity.isFullyFrozen();
        renderState.isBaby = entity.isBaby();
        renderState.isInWater = entity.isInWater();
        renderState.isAutoSpinAttack = entity.isAutoSpinAttack();
        renderState.hasRedOverlay = entity.hurtTime > 0 || entity.deathTime > 0;
        Item item = helmetStack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof AbstractSkullBlock) {
            AbstractSkullBlock skullBlock = (AbstractSkullBlock)item;
            renderState.wornHeadType = skullBlock.getType();
            renderState.wornHeadProfile = (ResolvableProfile)helmetStack.get(DataComponents.PROFILE);
            renderState.headItem.clear();
        } else {
            renderState.wornHeadType = null;
            renderState.wornHeadProfile = null;
            if (!HumanoidArmorLayer.shouldRender((ItemStack)helmetStack, (EquipmentSlot)EquipmentSlot.HEAD)) {
                this.itemModelResolver.updateForLiving(renderState.headItem, helmetStack, ItemDisplayContext.HEAD, entity);
            } else {
                renderState.headItem.clear();
            }
        }
        renderState.deathTime = entity.deathTime > 0 ? (float)entity.deathTime + partialTick : 0.0f;
        renderState.isInvisibleToPlayer = renderState.isInvisible && entity.isInvisibleTo((Player)minecraft.player);
    }

    @Override
    public void fireCompileRenderLayersEvent() {
        GeckoLibServices.Client.EVENTS.fireCompileEntityRenderLayers(this);
    }

    @Override
    public void fireCompileRenderStateEvent(T animatable, Void relatedObject, R renderState, float partialTick) {
        GeckoLibServices.Client.EVENTS.fireCompileEntityRenderState(this, renderState, animatable);
    }

    @Override
    public boolean firePreRenderEvent(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState) {
        return GeckoLibServices.Client.EVENTS.fireEntityPreRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    @Override
    public void firePostRenderEvent(R renderState, PoseStack poseStack, BakedGeoModel model, SubmitNodeCollector renderTasks, CameraRenderState cameraState) {
        GeckoLibServices.Client.EVENTS.fireEntityPostRender(this, renderState, poseStack, model, renderTasks, cameraState);
    }

    protected <S extends LivingEntityRenderState> S convertRenderStateToLiving(R renderState) {
        return (S)((LivingEntityRenderState)renderState);
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public final R createRenderState() {
        return null;
    }
}

