/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.base.GeoRenderState;
import software.bernie.geckolib.renderer.base.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class TextureLayerGeoLayer<T extends GeoAnimatable, O, R extends GeoRenderState>
extends GeoRenderLayer<T, O, R> {
    protected final ResourceLocation texture;
    protected final Function<ResourceLocation, RenderType> renderType;

    TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer) {
        this(renderer, MissingTextureAtlasSprite.getLocation(), null);
    }

    public TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer, ResourceLocation texture) {
        this(renderer, texture, null);
    }

    public TextureLayerGeoLayer(GeoRenderer<T, O, R> renderer, ResourceLocation texture, Function<ResourceLocation, RenderType> renderType) {
        super(renderer);
        this.texture = texture;
        this.renderType = renderType;
    }

    @Override
    protected ResourceLocation getTextureResource(R renderState) {
        return this.texture;
    }

    protected RenderType getRenderType(R renderState) {
        ResourceLocation texture = this.getTextureResource(renderState);
        if (this.renderType == null) {
            return this.renderer.getRenderType(renderState, texture);
        }
        return this.renderType.apply(texture);
    }

    @Override
    public void submitRenderTask(R renderState, PoseStack poseStack, BakedGeoModel bakedModel, SubmitNodeCollector renderTasks, CameraRenderState cameraState, int packedLight, int packedOverlay, int renderColor, boolean didRenderModel) {
        if (!didRenderModel) {
            return;
        }
        RenderType renderType = this.getRenderType(renderState);
        if (renderType != null) {
            this.renderer.buildRenderTask(renderState, poseStack, bakedModel, this.renderer.getGeoModel(), renderTasks.order(1), cameraState, renderType, packedLight, packedOverlay, renderColor, null);
        }
    }
}

